/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.ConfirmSubscriptionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ConfirmSubscriptionRequestMarshaller
implements Marshaller<Request<ConfirmSubscriptionRequest>, ConfirmSubscriptionRequest> {
    public Request<ConfirmSubscriptionRequest> marshall(ConfirmSubscriptionRequest confirmSubscriptionRequest) {
        String prefix;
        if (confirmSubscriptionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ConfirmSubscriptionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)confirmSubscriptionRequest, "AmazonSNS");
        request.addParameter("Action", "ConfirmSubscription");
        request.addParameter("Version", "2010-03-31");
        if (confirmSubscriptionRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = confirmSubscriptionRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (confirmSubscriptionRequest.getToken() != null) {
            prefix = "Token";
            String token = confirmSubscriptionRequest.getToken();
            request.addParameter(prefix, StringUtils.fromString((String)token));
        }
        if (confirmSubscriptionRequest.getAuthenticateOnUnsubscribe() != null) {
            prefix = "AuthenticateOnUnsubscribe";
            String authenticateOnUnsubscribe = confirmSubscriptionRequest.getAuthenticateOnUnsubscribe();
            request.addParameter(prefix, StringUtils.fromString((String)authenticateOnUnsubscribe));
        }
        return request;
    }
}

