/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.CreatePlatformApplicationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class CreatePlatformApplicationRequestMarshaller
implements Marshaller<Request<CreatePlatformApplicationRequest>, CreatePlatformApplicationRequest> {
    public Request<CreatePlatformApplicationRequest> marshall(CreatePlatformApplicationRequest createPlatformApplicationRequest) {
        String prefix;
        if (createPlatformApplicationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(CreatePlatformApplicationRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createPlatformApplicationRequest, "AmazonSNS");
        request.addParameter("Action", "CreatePlatformApplication");
        request.addParameter("Version", "2010-03-31");
        if (createPlatformApplicationRequest.getName() != null) {
            prefix = "Name";
            String name = createPlatformApplicationRequest.getName();
            request.addParameter(prefix, StringUtils.fromString((String)name));
        }
        if (createPlatformApplicationRequest.getPlatform() != null) {
            prefix = "Platform";
            String platform = createPlatformApplicationRequest.getPlatform();
            request.addParameter(prefix, StringUtils.fromString((String)platform));
        }
        if (createPlatformApplicationRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = createPlatformApplicationRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

