/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.GetSMSAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class GetSMSAttributesRequestMarshaller
implements Marshaller<Request<GetSMSAttributesRequest>, GetSMSAttributesRequest> {
    public Request<GetSMSAttributesRequest> marshall(GetSMSAttributesRequest getSMSAttributesRequest) {
        if (getSMSAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(GetSMSAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getSMSAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "GetSMSAttributes");
        request.addParameter("Version", "2010-03-31");
        if (getSMSAttributesRequest.getAttributes() != null) {
            String prefix = "attributes";
            List<String> attributes = getSMSAttributesRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix;
            for (String attributesItem : attributes) {
                prefix = attributesPrefix + ".member." + attributesIndex;
                if (attributesItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)attributesItem));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

