/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.OptInPhoneNumberRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class OptInPhoneNumberRequestMarshaller
implements Marshaller<Request<OptInPhoneNumberRequest>, OptInPhoneNumberRequest> {
    public Request<OptInPhoneNumberRequest> marshall(OptInPhoneNumberRequest optInPhoneNumberRequest) {
        if (optInPhoneNumberRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(OptInPhoneNumberRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)optInPhoneNumberRequest, "AmazonSNS");
        request.addParameter("Action", "OptInPhoneNumber");
        request.addParameter("Version", "2010-03-31");
        if (optInPhoneNumberRequest.getPhoneNumber() != null) {
            String prefix = "phoneNumber";
            String phoneNumber = optInPhoneNumberRequest.getPhoneNumber();
            request.addParameter(prefix, StringUtils.fromString((String)phoneNumber));
        }
        return request;
    }
}

