/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.MessageAttributeValue;
import com.amazonaws.services.sns.model.PublishRequest;
import com.amazonaws.services.sns.model.transform.MessageAttributeValueStaxMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class PublishRequestMarshaller
implements Marshaller<Request<PublishRequest>, PublishRequest> {
    public Request<PublishRequest> marshall(PublishRequest publishRequest) {
        String prefix;
        if (publishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(PublishRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)publishRequest, "AmazonSNS");
        request.addParameter("Action", "Publish");
        request.addParameter("Version", "2010-03-31");
        if (publishRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = publishRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (publishRequest.getTargetArn() != null) {
            prefix = "TargetArn";
            String targetArn = publishRequest.getTargetArn();
            request.addParameter(prefix, StringUtils.fromString((String)targetArn));
        }
        if (publishRequest.getPhoneNumber() != null) {
            prefix = "PhoneNumber";
            String phoneNumber = publishRequest.getPhoneNumber();
            request.addParameter(prefix, StringUtils.fromString((String)phoneNumber));
        }
        if (publishRequest.getMessage() != null) {
            prefix = "Message";
            String message = publishRequest.getMessage();
            request.addParameter(prefix, StringUtils.fromString((String)message));
        }
        if (publishRequest.getSubject() != null) {
            prefix = "Subject";
            String subject = publishRequest.getSubject();
            request.addParameter(prefix, StringUtils.fromString((String)subject));
        }
        if (publishRequest.getMessageStructure() != null) {
            prefix = "MessageStructure";
            String messageStructure = publishRequest.getMessageStructure();
            request.addParameter(prefix, StringUtils.fromString((String)messageStructure));
        }
        if (publishRequest.getMessageAttributes() != null) {
            prefix = "MessageAttributes";
            Map<String, MessageAttributeValue> messageAttributes = publishRequest.getMessageAttributes();
            int messageAttributesIndex = 1;
            String messageAttributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, MessageAttributeValue> messageAttributesEntry : messageAttributes.entrySet()) {
                prefix = messageAttributesPrefix + messageAttributesIndex;
                if (messageAttributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".Name", StringUtils.fromString((String)messageAttributesEntry.getKey()));
                }
                prefix = prefix + ".Value";
                if (messageAttributesEntry.getValue() != null) {
                    MessageAttributeValue messageAttributesValue = messageAttributesEntry.getValue();
                    MessageAttributeValueStaxMarshaller.getInstance().marshall(messageAttributesValue, (Request<?>)request, prefix + ".");
                }
                ++messageAttributesIndex;
            }
            prefix = messageAttributesPrefix;
        }
        if (publishRequest.getMessageDeduplicationId() != null) {
            prefix = "MessageDeduplicationId";
            String messageDeduplicationId = publishRequest.getMessageDeduplicationId();
            request.addParameter(prefix, StringUtils.fromString((String)messageDeduplicationId));
        }
        if (publishRequest.getMessageGroupId() != null) {
            prefix = "MessageGroupId";
            String messageGroupId = publishRequest.getMessageGroupId();
            request.addParameter(prefix, StringUtils.fromString((String)messageGroupId));
        }
        return request;
    }
}

