/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetPlatformApplicationAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SetPlatformApplicationAttributesRequestMarshaller
implements Marshaller<Request<SetPlatformApplicationAttributesRequest>, SetPlatformApplicationAttributesRequest> {
    public Request<SetPlatformApplicationAttributesRequest> marshall(SetPlatformApplicationAttributesRequest setPlatformApplicationAttributesRequest) {
        String prefix;
        if (setPlatformApplicationAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetPlatformApplicationAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setPlatformApplicationAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetPlatformApplicationAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setPlatformApplicationAttributesRequest.getPlatformApplicationArn() != null) {
            prefix = "PlatformApplicationArn";
            String platformApplicationArn = setPlatformApplicationAttributesRequest.getPlatformApplicationArn();
            request.addParameter(prefix, StringUtils.fromString((String)platformApplicationArn));
        }
        if (setPlatformApplicationAttributesRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = setPlatformApplicationAttributesRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            String string = attributesPrefix;
        }
        return request;
    }
}

