/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SetTopicAttributesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SetTopicAttributesRequestMarshaller
implements Marshaller<Request<SetTopicAttributesRequest>, SetTopicAttributesRequest> {
    public Request<SetTopicAttributesRequest> marshall(SetTopicAttributesRequest setTopicAttributesRequest) {
        String prefix;
        if (setTopicAttributesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SetTopicAttributesRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)setTopicAttributesRequest, "AmazonSNS");
        request.addParameter("Action", "SetTopicAttributes");
        request.addParameter("Version", "2010-03-31");
        if (setTopicAttributesRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = setTopicAttributesRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (setTopicAttributesRequest.getAttributeName() != null) {
            prefix = "AttributeName";
            String attributeName = setTopicAttributesRequest.getAttributeName();
            request.addParameter(prefix, StringUtils.fromString((String)attributeName));
        }
        if (setTopicAttributesRequest.getAttributeValue() != null) {
            prefix = "AttributeValue";
            String attributeValue = setTopicAttributesRequest.getAttributeValue();
            request.addParameter(prefix, StringUtils.fromString((String)attributeValue));
        }
        return request;
    }
}

