/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.SubscribeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Map;

public class SubscribeRequestMarshaller
implements Marshaller<Request<SubscribeRequest>, SubscribeRequest> {
    public Request<SubscribeRequest> marshall(SubscribeRequest subscribeRequest) {
        String prefix;
        if (subscribeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(SubscribeRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)subscribeRequest, "AmazonSNS");
        request.addParameter("Action", "Subscribe");
        request.addParameter("Version", "2010-03-31");
        if (subscribeRequest.getTopicArn() != null) {
            prefix = "TopicArn";
            String topicArn = subscribeRequest.getTopicArn();
            request.addParameter(prefix, StringUtils.fromString((String)topicArn));
        }
        if (subscribeRequest.getProtocol() != null) {
            prefix = "Protocol";
            String protocol = subscribeRequest.getProtocol();
            request.addParameter(prefix, StringUtils.fromString((String)protocol));
        }
        if (subscribeRequest.getEndpoint() != null) {
            prefix = "Endpoint";
            String endpoint = subscribeRequest.getEndpoint();
            request.addParameter(prefix, StringUtils.fromString((String)endpoint));
        }
        if (subscribeRequest.getAttributes() != null) {
            prefix = "Attributes";
            Map<String, String> attributes = subscribeRequest.getAttributes();
            int attributesIndex = 1;
            String attributesPrefix = prefix + ".entry.";
            for (Map.Entry<String, String> attributesEntry : attributes.entrySet()) {
                prefix = attributesPrefix + attributesIndex;
                if (attributesEntry.getKey() != null) {
                    request.addParameter(prefix + ".key", StringUtils.fromString((String)attributesEntry.getKey()));
                }
                prefix = prefix + ".value";
                if (attributesEntry.getValue() != null) {
                    String attributesValue = attributesEntry.getValue();
                    request.addParameter(prefix, StringUtils.fromString((String)attributesValue));
                }
                ++attributesIndex;
            }
            prefix = attributesPrefix;
        }
        if (subscribeRequest.getReturnSubscriptionArn() != null) {
            prefix = "ReturnSubscriptionArn";
            Boolean returnSubscriptionArn = subscribeRequest.getReturnSubscriptionArn();
            request.addParameter(prefix, StringUtils.fromBoolean((Boolean)returnSubscriptionArn));
        }
        return request;
    }
}

