/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sns.model.UntagResourceRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class UntagResourceRequestMarshaller
implements Marshaller<Request<UntagResourceRequest>, UntagResourceRequest> {
    public Request<UntagResourceRequest> marshall(UntagResourceRequest untagResourceRequest) {
        String prefix;
        if (untagResourceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(UntagResourceRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)untagResourceRequest, "AmazonSNS");
        request.addParameter("Action", "UntagResource");
        request.addParameter("Version", "2010-03-31");
        if (untagResourceRequest.getResourceArn() != null) {
            prefix = "ResourceArn";
            String resourceArn = untagResourceRequest.getResourceArn();
            request.addParameter(prefix, StringUtils.fromString((String)resourceArn));
        }
        if (untagResourceRequest.getTagKeys() != null) {
            prefix = "TagKeys";
            List<String> tagKeys = untagResourceRequest.getTagKeys();
            int tagKeysIndex = 1;
            String tagKeysPrefix = prefix;
            for (String tagKeysItem : tagKeys) {
                prefix = tagKeysPrefix + ".member." + tagKeysIndex;
                if (tagKeysItem != null) {
                    request.addParameter(prefix, StringUtils.fromString((String)tagKeysItem));
                }
                ++tagKeysIndex;
            }
            String string = tagKeysPrefix;
        }
        return request;
    }
}

