/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ChangeMessageVisibilityRequestMarshaller
implements Marshaller<Request<ChangeMessageVisibilityRequest>, ChangeMessageVisibilityRequest> {
    public Request<ChangeMessageVisibilityRequest> marshall(ChangeMessageVisibilityRequest changeMessageVisibilityRequest) {
        String prefix;
        if (changeMessageVisibilityRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(ChangeMessageVisibilityRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)changeMessageVisibilityRequest, "AmazonSQS");
        request.addParameter("Action", "ChangeMessageVisibility");
        request.addParameter("Version", "2012-11-05");
        if (changeMessageVisibilityRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = changeMessageVisibilityRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (changeMessageVisibilityRequest.getReceiptHandle() != null) {
            prefix = "ReceiptHandle";
            String receiptHandle = changeMessageVisibilityRequest.getReceiptHandle();
            request.addParameter(prefix, StringUtils.fromString((String)receiptHandle));
        }
        if (changeMessageVisibilityRequest.getVisibilityTimeout() != null) {
            prefix = "VisibilityTimeout";
            Integer visibilityTimeout = changeMessageVisibilityRequest.getVisibilityTimeout();
            request.addParameter(prefix, StringUtils.fromInteger((Integer)visibilityTimeout));
        }
        return request;
    }
}

