/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DeleteMessageRequestMarshaller
implements Marshaller<Request<DeleteMessageRequest>, DeleteMessageRequest> {
    public Request<DeleteMessageRequest> marshall(DeleteMessageRequest deleteMessageRequest) {
        String prefix;
        if (deleteMessageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(DeleteMessageRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteMessageRequest, "AmazonSQS");
        request.addParameter("Action", "DeleteMessage");
        request.addParameter("Version", "2012-11-05");
        if (deleteMessageRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = deleteMessageRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (deleteMessageRequest.getReceiptHandle() != null) {
            prefix = "ReceiptHandle";
            String receiptHandle = deleteMessageRequest.getReceiptHandle();
            request.addParameter(prefix, StringUtils.fromString((String)receiptHandle));
        }
        return request;
    }
}

