/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.sqs.model.RemovePermissionRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RemovePermissionRequestMarshaller
implements Marshaller<Request<RemovePermissionRequest>, RemovePermissionRequest> {
    public Request<RemovePermissionRequest> marshall(RemovePermissionRequest removePermissionRequest) {
        String prefix;
        if (removePermissionRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(RemovePermissionRequest)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)removePermissionRequest, "AmazonSQS");
        request.addParameter("Action", "RemovePermission");
        request.addParameter("Version", "2012-11-05");
        if (removePermissionRequest.getQueueUrl() != null) {
            prefix = "QueueUrl";
            String queueUrl = removePermissionRequest.getQueueUrl();
            request.addParameter(prefix, StringUtils.fromString((String)queueUrl));
        }
        if (removePermissionRequest.getLabel() != null) {
            prefix = "Label";
            String label = removePermissionRequest.getLabel();
            request.addParameter(prefix, StringUtils.fromString((String)label));
        }
        return request;
    }
}

