/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.ArrowTypeComparator;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.SchemaAware;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintEvaluator;
import com.google.common.base.MoreObjects;
import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorLoader;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Block
extends SchemaAware
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(Block.class);
    private final String allocatorId;
    private final Schema schema;
    private final VectorSchemaRoot vectorSchema;
    private ConstraintEvaluator constraintEvaluator = ConstraintEvaluator.emptyEvaluator();

    protected Block(String allocatorId, Schema schema, VectorSchemaRoot vectorSchema) {
        Objects.requireNonNull(allocatorId, "allocatorId is null");
        Objects.requireNonNull(schema, "schema is null");
        Objects.requireNonNull(vectorSchema, "vectorSchema is null");
        this.allocatorId = allocatorId;
        this.schema = schema;
        this.vectorSchema = vectorSchema;
    }

    public void constrain(ConstraintEvaluator constraintEvaluator) {
        this.constraintEvaluator = constraintEvaluator != null ? constraintEvaluator : ConstraintEvaluator.emptyEvaluator();
    }

    public ConstraintEvaluator getConstraintEvaluator() {
        return this.constraintEvaluator;
    }

    public String getAllocatorId() {
        return this.allocatorId;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public boolean setValue(String fieldName, int row, Object value) {
        if (this.constraintEvaluator.apply(fieldName, value)) {
            BlockUtils.setValue(this.getFieldVector(fieldName), row, value);
            return true;
        }
        return false;
    }

    public boolean offerValue(String fieldName, int row, Object value) {
        if (this.constraintEvaluator.apply(fieldName, value)) {
            FieldVector vector = this.getFieldVector(fieldName);
            if (vector != null) {
                BlockUtils.setValue(vector, row, value);
            }
            return true;
        }
        return false;
    }

    public boolean setComplexValue(String fieldName, int row, FieldResolver fieldResolver, Object value) {
        FieldVector vector = this.getFieldVector(fieldName);
        BlockUtils.setComplexValue(vector, row, fieldResolver, value);
        return true;
    }

    public boolean offerComplexValue(String fieldName, int row, FieldResolver fieldResolver, Object value) {
        FieldVector vector = this.getFieldVector(fieldName);
        if (vector != null) {
            BlockUtils.setComplexValue(vector, row, fieldResolver, value);
        }
        return true;
    }

    protected VectorSchemaRoot getVectorSchema() {
        return this.vectorSchema;
    }

    public void setRowCount(int rowCount) {
        this.vectorSchema.setRowCount(rowCount);
    }

    public int getRowCount() {
        return this.vectorSchema.getRowCount();
    }

    public FieldReader getFieldReader(String fieldName) {
        return this.vectorSchema.getVector(fieldName).getReader();
    }

    public FieldVector getFieldVector(String fieldName) {
        return this.vectorSchema.getVector(fieldName);
    }

    public List<FieldReader> getFieldReaders() {
        ArrayList<FieldReader> readers = new ArrayList<FieldReader>();
        for (FieldVector next : this.vectorSchema.getFieldVectors()) {
            readers.add(next.getReader());
        }
        return readers;
    }

    @Transient
    public long getSize() {
        long size = 0L;
        for (FieldVector next : this.vectorSchema.getFieldVectors()) {
            size += (long)next.getBufferSize();
        }
        return size;
    }

    public List<FieldVector> getFieldVectors() {
        return this.vectorSchema.getFieldVectors();
    }

    public ArrowRecordBatch getRecordBatch() {
        VectorUnloader vectorUnloader = new VectorUnloader(this.vectorSchema);
        return vectorUnloader.getRecordBatch();
    }

    public void loadRecordBatch(ArrowRecordBatch batch) {
        VectorLoader vectorLoader = new VectorLoader(this.vectorSchema);
        vectorLoader.load(batch);
        batch.close();
    }

    @Override
    public void close() throws Exception {
        this.vectorSchema.close();
    }

    @Override
    protected Schema internalGetSchema() {
        return this.schema;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block that = (Block)o;
        if (this.schema.getFields().size() != that.schema.getFields().size()) {
            return false;
        }
        if (this.vectorSchema.getRowCount() != that.vectorSchema.getRowCount()) {
            return false;
        }
        try {
            for (Field next : this.schema.getFields()) {
                FieldReader thisReader = this.vectorSchema.getVector(next.getName()).getReader();
                FieldReader thatReader = that.vectorSchema.getVector(next.getName()).getReader();
                for (int i = 0; i < this.vectorSchema.getRowCount(); ++i) {
                    thisReader.setPosition(i);
                    thatReader.setPosition(i);
                    if (ArrowTypeComparator.compare(thisReader, thisReader.readObject(), thatReader.readObject()) == 0) continue;
                    return false;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            logger.warn("equals: ", (Throwable)ex);
            return false;
        }
        return true;
    }

    public boolean equalsAsSet(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Block that = (Block)o;
        if (this.schema.getFields().size() != that.schema.getFields().size()) {
            return false;
        }
        if (this.vectorSchema.getRowCount() != that.vectorSchema.getRowCount()) {
            return false;
        }
        try {
            for (Field next : this.schema.getFields()) {
                FieldReader thisReader = this.vectorSchema.getVector(next.getName()).getReader();
                FieldReader thatReader = that.vectorSchema.getVector(next.getName()).getReader();
                for (int i = 0; i < this.vectorSchema.getRowCount(); ++i) {
                    thisReader.setPosition(i);
                    Types.MinorType type = thisReader.getMinorType();
                    Object val = thisReader.readObject();
                    boolean matched = false;
                    for (int j = 0; j < that.vectorSchema.getRowCount(); ++j) {
                        thatReader.setPosition(j);
                        if (ArrowTypeComparator.compare(thatReader, val, thatReader.readObject()) != 0) continue;
                        matched = true;
                    }
                    if (matched) continue;
                    return false;
                }
            }
        }
        catch (RuntimeException ex) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashcode = 0;
        for (Map.Entry entry : this.schema.getCustomMetadata().entrySet()) {
            hashcode += Objects.hashCode(entry);
        }
        for (Field field : this.schema.getFields()) {
            FieldReader thisReader = this.vectorSchema.getVector(field.getName()).getReader();
            for (int i = 0; i < this.vectorSchema.getRowCount(); ++i) {
                thisReader.setPosition(i);
                hashcode = 31 * hashcode + Objects.hashCode(thisReader.readObject());
            }
        }
        return hashcode;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        helper.add("rows", this.getRowCount());
        int rowsToPrint = this.vectorSchema.getRowCount() > 10 ? 10 : this.vectorSchema.getRowCount();
        for (Field next : this.schema.getFields()) {
            FieldReader thisReader = this.vectorSchema.getVector(next.getName()).getReader();
            ArrayList<String> values = new ArrayList<String>();
            int originalReaderPosition = thisReader.getPosition();
            for (int i = 0; i < rowsToPrint; ++i) {
                thisReader.setPosition(i);
                values.add(BlockUtils.fieldToString(thisReader));
            }
            thisReader.setPosition(originalReaderPosition);
            helper.add(next.getName(), values);
        }
        return helper.toString();
    }
}

