/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import io.netty.buffer.ArrowBuf;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.util.VisibleForTesting;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DateMilliVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMilliTZVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.UInt1Vector;
import org.apache.arrow.vector.UInt2Vector;
import org.apache.arrow.vector.UInt4Vector;
import org.apache.arrow.vector.UInt8Vector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.arrow.vector.complex.impl.NullableStructWriter;
import org.apache.arrow.vector.complex.impl.UnionListWriter;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.complex.writer.BaseWriter;
import org.apache.arrow.vector.complex.writer.FieldWriter;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.arrow.vector.util.Text;
import org.apache.commons.codec.Charsets;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.MutableDateTime;
import org.joda.time.ReadableInstant;

public class BlockUtils {
    public static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    public static final MutableDateTime EPOCH = new MutableDateTime();
    private static final char[] HEX_ARRAY;

    public static Block newBlock(BlockAllocator allocator, String columnName, ArrowType type, Object ... values) {
        return BlockUtils.newBlock(allocator, columnName, type, Arrays.asList(values));
    }

    public static Block newBlock(BlockAllocator allocator, String columnName, ArrowType type, Collection<Object> values) {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(columnName, type);
        Schema schema = schemaBuilder.build();
        Block block = allocator.createBlock(schema);
        int count = 0;
        for (Object next : values) {
            try {
                BlockUtils.setValue(block.getFieldVector(columnName), count++, next);
            }
            catch (Exception ex) {
                throw new RuntimeException("Error for " + type + " " + columnName + " " + next, ex);
            }
        }
        block.setRowCount(count);
        return block;
    }

    public static Block newEmptyBlock(BlockAllocator allocator, String columnName, ArrowType type) {
        SchemaBuilder schemaBuilder = new SchemaBuilder();
        schemaBuilder.addField(columnName, type);
        Schema schema = schemaBuilder.build();
        return allocator.createBlock(schema);
    }

    public static void setComplexValue(FieldVector vector, int pos, FieldResolver resolver, Object value) {
        if (vector instanceof ListVector) {
            if (value != null) {
                UnionListWriter writer = ((ListVector)vector).getWriter();
                writer.setPosition(pos);
                BlockUtils.writeList(vector.getAllocator(), (FieldWriter)writer, vector.getField(), pos, (List)value, resolver);
                ((ListVector)vector).setNotNull(pos);
            }
        } else if (vector instanceof StructVector) {
            NullableStructWriter writer = ((StructVector)vector).getWriter();
            writer.setPosition(pos);
            BlockUtils.writeStruct(vector.getAllocator(), (BaseWriter.StructWriter)writer, vector.getField(), pos, value, resolver);
        } else {
            throw new RuntimeException("Unsupported 'Complex' vector " + vector.getClass().getSimpleName() + " for field " + vector.getField().getName());
        }
    }

    public static void setValue(FieldVector vector, int pos, Object value) {
        try {
            if (value == null) {
                BlockUtils.setNullValue(vector, pos);
                return;
            }
            switch (vector.getMinorType()) {
                case TIMESTAMPMILLITZ: {
                    if (value instanceof org.joda.time.LocalDateTime) {
                        DateTimeZone dtz = ((org.joda.time.LocalDateTime)value).getChronology().getZone();
                        long dateTimeWithZone = ((org.joda.time.LocalDateTime)value).toDateTime(dtz).getMillis();
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                    }
                    if (value instanceof ZonedDateTime) {
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)value);
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    if (value instanceof LocalDateTime) {
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(((LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli(), UTC_ZONE_ID.getId());
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    if (value instanceof Date) {
                        long ldtInLong = Instant.ofEpochMilli(((Date)value).getTime()).atZone(UTC_ZONE_ID).toInstant().toEpochMilli();
                        long dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(ldtInLong, UTC_ZONE_ID.getId());
                        ((TimeStampMilliTZVector)vector).setSafe(pos, dateTimeWithZone);
                        break;
                    }
                    ((TimeStampMilliTZVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case DATEMILLI: {
                    if (value instanceof Date) {
                        ((DateMilliVector)vector).setSafe(pos, ((Date)value).getTime());
                        break;
                    }
                    if (value instanceof LocalDateTime) {
                        ((DateMilliVector)vector).setSafe(pos, ((LocalDateTime)value).atZone(UTC_ZONE_ID).toInstant().toEpochMilli());
                        break;
                    }
                    ((DateMilliVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case DATEDAY: {
                    if (value instanceof Date) {
                        Days days = Days.daysBetween((ReadableInstant)EPOCH, (ReadableInstant)new DateTime(((Date)value).getTime()));
                        ((DateDayVector)vector).setSafe(pos, days.getDays());
                        break;
                    }
                    if (value instanceof LocalDate) {
                        int days = (int)((LocalDate)value).toEpochDay();
                        ((DateDayVector)vector).setSafe(pos, days);
                        break;
                    }
                    if (value instanceof Long) {
                        ((DateDayVector)vector).setSafe(pos, ((Long)value).intValue());
                        break;
                    }
                    ((DateDayVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case FLOAT8: {
                    ((Float8Vector)vector).setSafe(pos, ((Double)value).doubleValue());
                    break;
                }
                case FLOAT4: {
                    ((Float4Vector)vector).setSafe(pos, ((Float)value).floatValue());
                    break;
                }
                case INT: {
                    if (value != null && value instanceof Long) {
                        ((IntVector)vector).setSafe(pos, ((Long)value).intValue());
                        break;
                    }
                    ((IntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case TINYINT: {
                    if (value instanceof Byte) {
                        ((TinyIntVector)vector).setSafe(pos, ((Byte)value).byteValue());
                        break;
                    }
                    ((TinyIntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case SMALLINT: {
                    if (value instanceof Short) {
                        ((SmallIntVector)vector).setSafe(pos, ((Short)value).shortValue());
                        break;
                    }
                    ((SmallIntVector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT1: {
                    ((UInt1Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT2: {
                    ((UInt2Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT4: {
                    ((UInt4Vector)vector).setSafe(pos, ((Integer)value).intValue());
                    break;
                }
                case UINT8: {
                    ((UInt8Vector)vector).setSafe(pos, (long)((Integer)value).intValue());
                    break;
                }
                case BIGINT: {
                    ((BigIntVector)vector).setSafe(pos, ((Long)value).longValue());
                    break;
                }
                case VARBINARY: {
                    ((VarBinaryVector)vector).setSafe(pos, (byte[])value);
                    break;
                }
                case DECIMAL: {
                    DecimalVector dVector = (DecimalVector)vector;
                    if (value instanceof Double) {
                        BigDecimal bdVal = new BigDecimal((Double)value);
                        bdVal = bdVal.setScale(dVector.getScale(), RoundingMode.HALF_UP);
                        dVector.setSafe(pos, bdVal);
                        break;
                    }
                    BigDecimal scaledValue = ((BigDecimal)value).setScale(dVector.getScale(), RoundingMode.HALF_UP);
                    ((DecimalVector)vector).setSafe(pos, scaledValue);
                    break;
                }
                case VARCHAR: {
                    if (value instanceof Text) {
                        ((VarCharVector)vector).setSafe(pos, (Text)value);
                        break;
                    }
                    ((VarCharVector)vector).setSafe(pos, value.toString().getBytes(Charsets.UTF_8));
                    break;
                }
                case BIT: {
                    if (value instanceof Integer && (Integer)value > 0) {
                        ((BitVector)vector).setSafe(pos, 1);
                        break;
                    }
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        ((BitVector)vector).setSafe(pos, 1);
                        break;
                    }
                    ((BitVector)vector).setSafe(pos, 0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
                }
            }
        }
        catch (RuntimeException ex) {
            String fieldName = vector != null ? vector.getField().getName() : "null_vector";
            throw new RuntimeException("Unable to set value for field " + fieldName + " using value " + value, ex);
        }
    }

    public static String rowToString(Block block, int row) {
        if (row > block.getRowCount()) {
            throw new IllegalArgumentException(row + " exceeds available rows " + block.getRowCount());
        }
        StringBuilder sb = new StringBuilder();
        for (FieldReader nextReader : block.getFieldReaders()) {
            try {
                nextReader.setPosition(row);
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("[");
                sb.append(nextReader.getField().getName());
                sb.append(" : ");
                sb.append(BlockUtils.fieldToString(nextReader));
                sb.append("]");
            }
            catch (RuntimeException ex) {
                throw new RuntimeException("Error processing field " + nextReader.getField().getName(), ex);
            }
        }
        return sb.toString();
    }

    public static String fieldToString(FieldReader reader) {
        switch (reader.getMinorType()) {
            case DATEDAY: {
                return String.valueOf(reader.readInteger());
            }
            case TIMESTAMPMILLITZ: {
                return String.valueOf(DateTimeFormatterUtil.constructZonedDateTime(reader.readLong()));
            }
            case DATEMILLI: {
                return String.valueOf(reader.readLocalDateTime());
            }
            case FLOAT8: 
            case FLOAT4: 
            case INT: 
            case UINT4: 
            case UINT8: 
            case BIGINT: 
            case VARCHAR: 
            case BIT: {
                return String.valueOf(reader.readObject());
            }
            case DECIMAL: {
                return String.valueOf(reader.readBigDecimal());
            }
            case SMALLINT: {
                return String.valueOf(reader.readShort());
            }
            case TINYINT: 
            case UINT1: {
                return Integer.valueOf(reader.readByte().byteValue()).toString();
            }
            case UINT2: {
                return Integer.valueOf(reader.readCharacter().charValue()).toString();
            }
            case VARBINARY: {
                return BlockUtils.bytesToHex(reader.readByteArray());
            }
            case STRUCT: {
                StringBuilder sb = new StringBuilder();
                sb.append("{");
                for (Field child : reader.getField().getChildren()) {
                    if (sb.length() > 3) {
                        sb.append(",");
                    }
                    sb.append("[");
                    sb.append(child.getName());
                    sb.append(" : ");
                    sb.append(BlockUtils.fieldToString(reader.reader(child.getName())));
                    sb.append("]");
                }
                sb.append("}");
                return sb.toString();
            }
            case LIST: {
                StringBuilder sbList = new StringBuilder();
                sbList.append("{");
                while (reader.next()) {
                    if (sbList.length() > 1) {
                        sbList.append(",");
                    }
                    sbList.append(BlockUtils.fieldToString(reader.reader()));
                }
                sbList.append("}");
                return sbList.toString();
            }
        }
        Object obj = reader.readObject();
        return reader.getMinorType() + " - " + (obj != null ? obj.getClass().toString() : "null") + "[ " + String.valueOf(obj) + " ]";
    }

    public static int copyRows(Block srcBlock, Block dstBlock, int firstRow, int lastRow) {
        if (firstRow > lastRow || lastRow > srcBlock.getRowCount() - 1) {
            throw new RuntimeException("src has " + srcBlock.getRowCount() + " but requested copy of " + firstRow + " to " + lastRow);
        }
        for (FieldReader src : srcBlock.getFieldReaders()) {
            int dstOffset = dstBlock.getRowCount();
            for (int i = firstRow; i <= lastRow; ++i) {
                FieldVector dst = dstBlock.getFieldVector(src.getField().getName());
                src.setPosition(i);
                BlockUtils.setValue(dst, dstOffset++, src.readObject());
            }
        }
        int rowsCopied = 1 + (lastRow - firstRow);
        dstBlock.setRowCount(dstBlock.getRowCount() + rowsCopied);
        return rowsCopied;
    }

    public static boolean isNullRow(Block block, int row) {
        if (row > block.getRowCount() - 1) {
            throw new RuntimeException("block has " + block.getRowCount() + " rows but requested to check " + row);
        }
        for (FieldReader src : block.getFieldReaders()) {
            src.setPosition(row);
            if (!src.isSet()) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    protected static void writeList(BufferAllocator allocator, FieldWriter writer, Field field, int pos, Iterable value, FieldResolver resolver) {
        if (value == null) {
            return;
        }
        Field child = null;
        if (field.getChildren() != null && !field.getChildren().isEmpty()) {
            child = (Field)field.getChildren().get(0);
        }
        writer.startList();
        block6: for (Object val : value) {
            if (val == null) continue;
            switch (Types.getMinorTypeForArrowType((ArrowType)child.getType())) {
                case LIST: {
                    BlockUtils.writeList(allocator, (FieldWriter)writer.list(), child, pos, (List)val, resolver);
                    continue block6;
                }
                case STRUCT: {
                    BlockUtils.writeStruct(allocator, writer.struct(), child, pos, val, resolver);
                    continue block6;
                }
            }
            BlockUtils.writeListValue(writer, child.getType(), allocator, val);
        }
        writer.endList();
    }

    @VisibleForTesting
    protected static void writeStruct(BufferAllocator allocator, BaseWriter.StructWriter writer, Field field, int pos, Object value, FieldResolver resolver) {
        if (value == null) {
            return;
        }
        writer.start();
        block4: for (Field nextChild : field.getChildren()) {
            Object childValue = resolver.getFieldValue(nextChild, value);
            switch (Types.getMinorTypeForArrowType((ArrowType)nextChild.getType())) {
                case LIST: {
                    BlockUtils.writeList(allocator, (FieldWriter)writer.list(nextChild.getName()), nextChild, pos, (List)childValue, resolver);
                    continue block4;
                }
                case STRUCT: {
                    BlockUtils.writeStruct(allocator, writer.struct(nextChild.getName()), nextChild, pos, childValue, resolver);
                    continue block4;
                }
            }
            BlockUtils.writeStructValue(writer, nextChild, allocator, childValue);
        }
        writer.end();
    }

    @VisibleForTesting
    public static Class getJavaType(Types.MinorType minorType) {
        switch (minorType) {
            case TIMESTAMPMILLITZ: {
                return ZonedDateTime.class;
            }
            case DATEMILLI: {
                return LocalDateTime.class;
            }
            case TINYINT: 
            case UINT1: {
                return Byte.class;
            }
            case SMALLINT: {
                return Short.class;
            }
            case UINT2: {
                return Character.class;
            }
            case DATEDAY: {
                return LocalDate.class;
            }
            case INT: 
            case UINT4: {
                return Integer.class;
            }
            case UINT8: 
            case BIGINT: {
                return Long.class;
            }
            case DECIMAL: {
                return BigDecimal.class;
            }
            case FLOAT4: {
                return Float.class;
            }
            case FLOAT8: {
                return Double.class;
            }
            case VARCHAR: {
                return String.class;
            }
            case VARBINARY: {
                return byte[].class;
            }
            case BIT: {
                return Boolean.class;
            }
            case LIST: {
                return List.class;
            }
            case STRUCT: {
                return Map.class;
            }
        }
        throw new IllegalArgumentException("Unknown type " + minorType);
    }

    /*
     * Unable to fully structure code
     */
    protected static void writeListValue(FieldWriter writer, ArrowType type, BufferAllocator allocator, Object value) {
        if (value == null) {
            return;
        }
        try {
            switch (1.$SwitchMap$org$apache$arrow$vector$types$Types$MinorType[Types.getMinorTypeForArrowType((ArrowType)type).ordinal()]) {
                case 1: {
                    if (value instanceof ZonedDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)value);
                    } else if (value instanceof LocalDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(((LocalDateTime)value).atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli(), BlockUtils.UTC_ZONE_ID.getId());
                    } else if (value instanceof Date) {
                        ldtInLong = Instant.ofEpochMilli(((Date)value).getTime()).atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli();
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(ldtInLong, BlockUtils.UTC_ZONE_ID.getId());
                    } else {
                        dateTimeWithZone = (Long)value;
                    }
                    writer.writeTimeStampMilliTZ(dateTimeWithZone);
                }
                case 2: {
                    if (value instanceof Date) {
                        writer.writeDateMilli(((Date)value).getTime());
                        break;
                    }
                    writer.writeDateMilli(((Long)value).longValue());
                    break;
                }
                case 3: {
                    if (value instanceof Date) {
                        days = Days.daysBetween((ReadableInstant)BlockUtils.EPOCH, (ReadableInstant)new DateTime(((Date)value).getTime()));
                        writer.writeDateDay(days.getDays());
                        break;
                    }
                    if (value instanceof LocalDate) {
                        days = (int)((LocalDate)value).toEpochDay();
                        writer.writeDateDay(days);
                        break;
                    }
                    if (value instanceof Long) {
                        writer.writeDateDay(((Long)value).intValue());
                        break;
                    }
                    writer.writeDateDay(((Integer)value).intValue());
                    break;
                }
                case 4: {
                    writer.float8().writeFloat8(((Double)value).doubleValue());
                    break;
                }
                case 5: {
                    writer.float4().writeFloat4(((Float)value).floatValue());
                    break;
                }
                case 6: {
                    if (value != null && value instanceof Long) {
                        writer.integer().writeInt(((Long)value).intValue());
                        break;
                    }
                    writer.integer().writeInt(((Integer)value).intValue());
                    break;
                }
                case 7: {
                    writer.tinyInt().writeTinyInt(((Byte)value).byteValue());
                    break;
                }
                case 8: {
                    writer.smallInt().writeSmallInt(((Short)value).shortValue());
                    break;
                }
                case 9: {
                    writer.uInt1().writeUInt1(((Byte)value).byteValue());
                    break;
                }
                case 10: {
                    writer.uInt2().writeUInt2(((Character)value).charValue());
                    break;
                }
                case 11: {
                    writer.uInt4().writeUInt4(((Integer)value).intValue());
                    break;
                }
                case 12: {
                    writer.uInt8().writeUInt8(((Long)value).longValue());
                    break;
                }
                case 13: {
                    writer.bigInt().writeBigInt(((Long)value).longValue());
                    break;
                }
                case 14: {
                    if (value instanceof ArrowBuf) {
                        buf = (ArrowBuf)value;
                        writer.varBinary().writeVarBinary(0, buf.capacity(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) break;
                    bytes = (byte[])value;
                    buf = allocator.buffer(bytes.length);
                    var8_18 = null;
                    buf.writeBytes(bytes);
                    writer.varBinary().writeVarBinary(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var8_18 == null) ** GOTO lbl92
                    try {
                        buf.close();
                    }
                    catch (Throwable var9_22) {
                        var8_18.addSuppressed(var9_22);
                    }
                    break;
lbl92:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var9_23) {
                        try {
                            var8_18 = var9_23;
                            throw var9_23;
                        }
                        catch (Throwable var10_26) {
                            if (buf != null) {
                                if (var8_18 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var11_31) {
                                        var8_18.addSuppressed(var11_31);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var10_26;
                        }
                    }
                }
                case 15: {
                    scale = ((ArrowType.Decimal)type).getScale();
                    if (value instanceof Double) {
                        precision = ((ArrowType.Decimal)type).getPrecision();
                        bdVal = new BigDecimal((Double)value);
                        bdVal = bdVal.setScale(scale, RoundingMode.HALF_UP);
                        writer.decimal().writeDecimal(bdVal);
                        break;
                    }
                    scaledValue = ((BigDecimal)value).setScale(scale, RoundingMode.HALF_UP);
                    writer.decimal().writeDecimal(scaledValue);
                    break;
                }
                case 16: {
                    if (value instanceof ArrowBuf) {
                        buf = (ArrowBuf)value;
                        writer.varChar().writeVarChar(0, buf.readableBytes(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) ** GOTO lbl158
                    bytes = (byte[])value;
                    buf = allocator.buffer(bytes.length);
                    var9_24 = null;
                    buf.writeBytes(bytes);
                    writer.varChar().writeVarChar(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var9_24 == null) ** GOTO lbl141
                    try {
                        buf.close();
                    }
                    catch (Throwable var10_27) {
                        var9_24.addSuppressed(var10_27);
                    }
                    break;
lbl141:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var10_28) {
                        try {
                            var9_24 = var10_28;
                            throw var10_28;
                        }
                        catch (Throwable var12_32) {
                            if (buf != null) {
                                if (var9_24 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var13_33) {
                                        var9_24.addSuppressed(var13_33);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var12_32;
                        }
                    }
lbl158:
                    // 1 sources

                    bytes = value.toString().getBytes(Charsets.UTF_8);
                    buf = allocator.buffer(bytes.length);
                    var9_25 = null;
                    buf.writeBytes(bytes);
                    writer.varChar().writeVarChar(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var9_25 == null) ** GOTO lbl173
                    try {
                        buf.close();
                    }
                    catch (Throwable var10_29) {
                        var9_25.addSuppressed(var10_29);
                    }
                    break;
lbl173:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var10_30) {
                        try {
                            var9_25 = var10_30;
                            throw var10_30;
                        }
                        catch (Throwable var14_34) {
                            if (buf != null) {
                                if (var9_25 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var15_35) {
                                        var9_25.addSuppressed(var15_35);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var14_34;
                        }
                    }
                }
                case 17: {
                    if (value instanceof Integer && (Integer)value > 0) {
                        writer.bit().writeBit(1);
                        break;
                    }
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        writer.bit().writeBit(1);
                        break;
                    }
                    writer.bit().writeBit(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + type);
                }
            }
        }
        catch (RuntimeException ex) {
            fieldName = writer.getField() != null ? writer.getField().getName() : "null_vector";
            throw new RuntimeException("Unable to write value for field " + fieldName + " using value " + value, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    protected static void writeStructValue(BaseWriter.StructWriter writer, Field field, BufferAllocator allocator, Object value) {
        if (value == null) {
            return;
        }
        type = field.getType();
        try {
            switch (1.$SwitchMap$org$apache$arrow$vector$types$Types$MinorType[Types.getMinorTypeForArrowType((ArrowType)type).ordinal()]) {
                case 1: {
                    if (value instanceof ZonedDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)value);
                    } else if (value instanceof LocalDateTime) {
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(((LocalDateTime)value).atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli(), BlockUtils.UTC_ZONE_ID.getId());
                    } else if (value instanceof Date) {
                        ldtInLong = Instant.ofEpochMilli(((Date)value).getTime()).atZone(BlockUtils.UTC_ZONE_ID).toInstant().toEpochMilli();
                        dateTimeWithZone = DateTimeFormatterUtil.packDateTimeWithZone(ldtInLong, BlockUtils.UTC_ZONE_ID.getId());
                    } else {
                        dateTimeWithZone = (Long)value;
                    }
                    writer.timeStampMilliTZ(field.getName()).writeTimeStampMilliTZ(dateTimeWithZone);
                }
                case 2: {
                    if (value instanceof Date) {
                        writer.dateMilli(field.getName()).writeDateMilli(((Date)value).getTime());
                        break;
                    }
                    writer.dateMilli(field.getName()).writeDateMilli(((Long)value).longValue());
                    break;
                }
                case 3: {
                    if (value instanceof Date) {
                        days = Days.daysBetween((ReadableInstant)BlockUtils.EPOCH, (ReadableInstant)new DateTime(((Date)value).getTime()));
                        writer.dateDay(field.getName()).writeDateDay(days.getDays());
                        break;
                    }
                    if (value instanceof LocalDate) {
                        days = (int)((LocalDate)value).toEpochDay();
                        writer.dateDay(field.getName()).writeDateDay(days);
                        break;
                    }
                    if (value instanceof Long) {
                        writer.dateDay(field.getName()).writeDateDay(((Long)value).intValue());
                        break;
                    }
                    writer.dateDay(field.getName()).writeDateDay(((Integer)value).intValue());
                    break;
                }
                case 4: {
                    writer.float8(field.getName()).writeFloat8(((Double)value).doubleValue());
                    break;
                }
                case 5: {
                    writer.float4(field.getName()).writeFloat4(((Float)value).floatValue());
                    break;
                }
                case 6: {
                    if (value != null && value instanceof Long) {
                        writer.integer(field.getName()).writeInt(((Long)value).intValue());
                        break;
                    }
                    writer.integer(field.getName()).writeInt(((Integer)value).intValue());
                    break;
                }
                case 7: {
                    writer.tinyInt(field.getName()).writeTinyInt(((Byte)value).byteValue());
                    break;
                }
                case 8: {
                    writer.smallInt(field.getName()).writeSmallInt(((Short)value).shortValue());
                    break;
                }
                case 9: {
                    writer.uInt1(field.getName()).writeUInt1(((Byte)value).byteValue());
                    break;
                }
                case 10: {
                    writer.uInt2(field.getName()).writeUInt2(((Character)value).charValue());
                    break;
                }
                case 11: {
                    writer.uInt4(field.getName()).writeUInt4(((Integer)value).intValue());
                    break;
                }
                case 12: {
                    writer.uInt8(field.getName()).writeUInt8(((Long)value).longValue());
                    break;
                }
                case 13: {
                    writer.bigInt(field.getName()).writeBigInt(((Long)value).longValue());
                    break;
                }
                case 14: {
                    if (value instanceof ArrowBuf) {
                        buf = (ArrowBuf)value;
                        writer.varBinary(field.getName()).writeVarBinary(0, buf.capacity(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) break;
                    bytes = (byte[])value;
                    buf = allocator.buffer(bytes.length);
                    var9_15 = null;
                    buf.writeBytes(bytes);
                    writer.varBinary(field.getName()).writeVarBinary(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var9_15 == null) ** GOTO lbl93
                    try {
                        buf.close();
                    }
                    catch (Throwable var10_21) {
                        var9_15.addSuppressed(var10_21);
                    }
                    break;
lbl93:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var10_22) {
                        try {
                            var9_15 = var10_22;
                            throw var10_22;
                        }
                        catch (Throwable var11_25) {
                            if (buf != null) {
                                if (var9_15 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var12_28) {
                                        var9_15.addSuppressed(var12_28);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var11_25;
                        }
                    }
                }
                case 15: {
                    scale = ((ArrowType.Decimal)type).getScale();
                    precision = ((ArrowType.Decimal)type).getPrecision();
                    if (value instanceof Double) {
                        bdVal = new BigDecimal((Double)value);
                        bdVal = bdVal.setScale(scale, RoundingMode.HALF_UP);
                        writer.decimal(field.getName(), scale, precision).writeDecimal(bdVal);
                        break;
                    }
                    scaledValue = ((BigDecimal)value).setScale(scale, RoundingMode.HALF_UP);
                    writer.decimal(field.getName(), scale, precision).writeDecimal(scaledValue);
                    break;
                }
                case 16: {
                    if (!(value instanceof String)) ** GOTO lbl155
                    bytes = ((String)value).getBytes(Charsets.UTF_8);
                    buf = allocator.buffer(bytes.length);
                    var11_26 = null;
                    buf.writeBytes(bytes);
                    writer.varChar(field.getName()).writeVarChar(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var11_26 == null) ** GOTO lbl138
                    try {
                        buf.close();
                    }
                    catch (Throwable var12_29) {
                        var11_26.addSuppressed(var12_29);
                    }
                    break;
lbl138:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var12_30) {
                        try {
                            var11_26 = var12_30;
                            throw var12_30;
                        }
                        catch (Throwable var13_33) {
                            if (buf != null) {
                                if (var11_26 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var14_34) {
                                        var11_26.addSuppressed(var14_34);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var13_33;
                        }
                    }
lbl155:
                    // 1 sources

                    if (value instanceof ArrowBuf) {
                        buf = (ArrowBuf)value;
                        writer.varChar(field.getName()).writeVarChar(0, buf.readableBytes(), buf);
                        break;
                    }
                    if (!(value instanceof byte[])) break;
                    bytes = (byte[])value;
                    buf = allocator.buffer(bytes.length);
                    var11_27 = null;
                    buf.writeBytes(bytes);
                    writer.varChar(field.getName()).writeVarChar(0, buf.readableBytes(), buf);
                    if (buf == null) break;
                    if (var11_27 == null) ** GOTO lbl175
                    try {
                        buf.close();
                    }
                    catch (Throwable var12_31) {
                        var11_27.addSuppressed(var12_31);
                    }
                    break;
lbl175:
                    // 1 sources

                    buf.close();
                    break;
                    catch (Throwable var12_32) {
                        try {
                            var11_27 = var12_32;
                            throw var12_32;
                        }
                        catch (Throwable var15_35) {
                            if (buf != null) {
                                if (var11_27 != null) {
                                    try {
                                        buf.close();
                                    }
                                    catch (Throwable var16_36) {
                                        var11_27.addSuppressed(var16_36);
                                    }
                                } else {
                                    buf.close();
                                }
                            }
                            throw var15_35;
                        }
                    }
                }
                case 17: {
                    if (value instanceof Integer && (Integer)value > 0) {
                        writer.bit(field.getName()).writeBit(1);
                        break;
                    }
                    if (value instanceof Boolean && ((Boolean)value).booleanValue()) {
                        writer.bit(field.getName()).writeBit(1);
                        break;
                    }
                    writer.bit(field.getName()).writeBit(0);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type " + type);
                }
            }
        }
        catch (RuntimeException ex) {
            throw new RuntimeException("Unable to write value for field " + field.getName() + " using value " + value, ex);
        }
    }

    private static void setNullValue(FieldVector vector, int pos) {
        switch (vector.getMinorType()) {
            case TIMESTAMPMILLITZ: {
                ((TimeStampMilliTZVector)vector).setNull(pos);
                break;
            }
            case DATEMILLI: {
                ((DateMilliVector)vector).setNull(pos);
                break;
            }
            case DATEDAY: {
                ((DateDayVector)vector).setNull(pos);
                break;
            }
            case FLOAT8: {
                ((Float8Vector)vector).setNull(pos);
                break;
            }
            case FLOAT4: {
                ((Float4Vector)vector).setNull(pos);
                break;
            }
            case INT: {
                ((IntVector)vector).setNull(pos);
                break;
            }
            case TINYINT: {
                ((TinyIntVector)vector).setNull(pos);
                break;
            }
            case SMALLINT: {
                ((SmallIntVector)vector).setNull(pos);
                break;
            }
            case UINT1: {
                ((UInt1Vector)vector).setNull(pos);
                break;
            }
            case UINT2: {
                ((UInt2Vector)vector).setNull(pos);
                break;
            }
            case UINT4: {
                ((UInt4Vector)vector).setNull(pos);
                break;
            }
            case UINT8: {
                ((UInt8Vector)vector).setNull(pos);
                break;
            }
            case BIGINT: {
                ((BigIntVector)vector).setNull(pos);
                break;
            }
            case VARBINARY: {
                ((VarBinaryVector)vector).setNull(pos);
                break;
            }
            case DECIMAL: {
                ((DecimalVector)vector).setNull(pos);
                break;
            }
            case VARCHAR: {
                ((VarCharVector)vector).setNull(pos);
                break;
            }
            case BIT: {
                ((BitVector)vector).setNull(pos);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
            }
        }
    }

    public static void unsetRow(int row, Block block) {
        block21: for (FieldVector vector : block.getFieldVectors()) {
            switch (vector.getMinorType()) {
                case TIMESTAMPMILLITZ: {
                    ((TimeStampMilliTZVector)vector).setNull(row);
                    continue block21;
                }
                case DATEDAY: {
                    ((DateDayVector)vector).setNull(row);
                    continue block21;
                }
                case DATEMILLI: {
                    ((DateMilliVector)vector).setNull(row);
                    continue block21;
                }
                case TINYINT: {
                    ((TinyIntVector)vector).setNull(row);
                    continue block21;
                }
                case UINT1: {
                    ((UInt1Vector)vector).setNull(row);
                    continue block21;
                }
                case SMALLINT: {
                    ((SmallIntVector)vector).setNull(row);
                    continue block21;
                }
                case UINT2: {
                    ((UInt2Vector)vector).setNull(row);
                    continue block21;
                }
                case UINT4: {
                    ((UInt4Vector)vector).setNull(row);
                    continue block21;
                }
                case INT: {
                    ((IntVector)vector).setNull(row);
                    continue block21;
                }
                case UINT8: {
                    ((UInt8Vector)vector).setNull(row);
                    continue block21;
                }
                case BIGINT: {
                    ((BigIntVector)vector).setNull(row);
                    continue block21;
                }
                case FLOAT4: {
                    ((Float4Vector)vector).setNull(row);
                    continue block21;
                }
                case FLOAT8: {
                    ((Float8Vector)vector).setNull(row);
                    continue block21;
                }
                case DECIMAL: {
                    ((DecimalVector)vector).setNull(row);
                    continue block21;
                }
                case VARBINARY: {
                    ((VarBinaryVector)vector).setNull(row);
                    continue block21;
                }
                case VARCHAR: {
                    ((VarCharVector)vector).setNull(row);
                    continue block21;
                }
                case BIT: {
                    ((BitVector)vector).setNull(row);
                    continue block21;
                }
                case STRUCT: {
                    ((StructVector)vector).setNull(row);
                    continue block21;
                }
                case LIST: {
                    UnionListWriter writer = ((ListVector)vector).getWriter();
                    writer.setPosition(row);
                    writer.startList();
                    writer.endList();
                    writer.setValueCount(0);
                    continue block21;
                }
            }
            throw new IllegalArgumentException("Unknown type " + vector.getMinorType());
        }
    }

    private BlockUtils() {
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    static {
        EPOCH.setDate(0L);
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }
}

