/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import java.util.HashSet;
import java.util.Set;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public enum SupportedTypes {
    BIT(Types.MinorType.BIT),
    DATEMILLI(Types.MinorType.DATEMILLI),
    DATEDAY(Types.MinorType.DATEDAY),
    TIMESTAMPMILLITZ(Types.MinorType.TIMESTAMPMILLITZ),
    FLOAT8(Types.MinorType.FLOAT8),
    FLOAT4(Types.MinorType.FLOAT4),
    INT(Types.MinorType.INT),
    TINYINT(Types.MinorType.TINYINT),
    SMALLINT(Types.MinorType.SMALLINT),
    BIGINT(Types.MinorType.BIGINT),
    VARBINARY(Types.MinorType.VARBINARY),
    DECIMAL(Types.MinorType.DECIMAL),
    VARCHAR(Types.MinorType.VARCHAR),
    STRUCT(Types.MinorType.STRUCT),
    LIST(Types.MinorType.LIST);

    private Types.MinorType arrowMinorType;
    static final Set<Types.MinorType> SUPPORTED_TYPES;

    private SupportedTypes(Types.MinorType arrowMinorType) {
        this.arrowMinorType = arrowMinorType;
    }

    public Types.MinorType getArrowMinorType() {
        return this.arrowMinorType;
    }

    public static boolean isSupported(Types.MinorType minorType) {
        return SUPPORTED_TYPES.contains(minorType);
    }

    public static boolean isSupported(ArrowType arrowType) {
        return SupportedTypes.isSupported(Types.getMinorTypeForArrowType((ArrowType)arrowType));
    }

    public static boolean isSupported(Field field) {
        if (!SupportedTypes.isSupported(Types.getMinorTypeForArrowType((ArrowType)field.getType()))) {
            return false;
        }
        if (field.getChildren() != null) {
            for (Field nextChild : field.getChildren()) {
                if (SupportedTypes.isSupported(nextChild)) continue;
                return false;
            }
        }
        return true;
    }

    public static void assertSupported(Field field) {
        if (!SupportedTypes.isSupported(field)) {
            throw new RuntimeException("Detected unsupported type[" + field.getType() + " / " + Types.getMinorTypeForArrowType((ArrowType)field.getType()) + " for column[" + field.getName() + "]");
        }
    }

    static {
        SUPPORTED_TYPES = new HashSet<Types.MinorType>();
        for (SupportedTypes next : SupportedTypes.values()) {
            SUPPORTED_TYPES.add(next.arrowMinorType);
        }
    }
}

