/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.predicate.ConstraintProjector;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.MarkerFactory;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintEvaluator
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintEvaluator.class);
    private final Constraints constraints;
    private final MarkerFactory markerFactory;
    private final Map<String, ArrowType> typeMap = new HashMap<String, ArrowType>();

    public ConstraintEvaluator(BlockAllocator allocator, Schema schema, Constraints constraints) {
        this.constraints = constraints;
        for (Field next : schema.getFields()) {
            this.typeMap.put(next.getName(), next.getType());
        }
        this.markerFactory = new MarkerFactory(allocator);
    }

    public static ConstraintEvaluator emptyEvaluator() {
        return new ConstraintEvaluator(null, SchemaBuilder.newBuilder().build(), new Constraints(new HashMap<String, ValueSet>()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean apply(String fieldName, Object value) {
        try {
            ValueSet constraint = this.constraints.getSummary().get(fieldName);
            if (constraint == null) return true;
            if (this.typeMap.get(fieldName) == null) return true;
            try (Marker marker = this.markerFactory.createNullable(this.typeMap.get(fieldName), value, Marker.Bound.EXACTLY);){
                boolean bl = constraint.containsValue(marker);
                return bl;
            }
        }
        catch (Exception ex) {
            RuntimeException runtimeException;
            if (ex instanceof RuntimeException) {
                runtimeException = (RuntimeException)ex;
                throw runtimeException;
            }
            runtimeException = new RuntimeException(ex);
            throw runtimeException;
        }
    }

    public Optional<ConstraintProjector> makeConstraintProjector(String fieldName) {
        ValueSet constraint = this.constraints.getSummary().get(fieldName);
        if (constraint != null && this.typeMap.get(fieldName) != null) {
            return Optional.of(value -> constraint.containsValue(value));
        }
        return Optional.empty();
    }

    @Override
    public void close() throws Exception {
        this.markerFactory.close();
    }
}

