/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.predicate;

import com.amazonaws.athena.connector.lambda.data.ArrowTypeComparator;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueMarker;
import java.util.Comparator;

public class ValueMarkerComparator
implements Comparator<ValueMarker> {
    private static final ValueMarkerComparator COMPARATOR = new ValueMarkerComparator();

    static int doCompare(ValueMarker o1, ValueMarker o2) {
        return COMPARATOR.compare(o1, o2);
    }

    @Override
    public int compare(ValueMarker o1, ValueMarker o2) {
        if (o1.isUpperUnbounded()) {
            return o2.isUpperUnbounded() ? 0 : 1;
        }
        if (o1.isLowerUnbounded()) {
            return o2.isLowerUnbounded() ? 0 : -1;
        }
        if (o2.isUpperUnbounded()) {
            return -1;
        }
        if (o2.isLowerUnbounded()) {
            return 1;
        }
        if (o1.isNullValue() || o2.isNullValue()) {
            if (o1.isNullValue() == o2.isNullValue()) {
                return 0;
            }
            return o1.isNullValue() & !o2.isNullValue() ? 1 : -1;
        }
        int compare = ArrowTypeComparator.compare(o1.getType(), o1.getValue(), o2.getValue());
        if (compare == 0) {
            if (o1.getBound() == o2.getBound()) {
                return 0;
            }
            if (o1.getBound() == Marker.Bound.BELOW) {
                return -1;
            }
            if (o1.getBound() == Marker.Bound.ABOVE) {
                return 1;
            }
            return o2.getBound() == Marker.Bound.BELOW ? 1 : -1;
        }
        return compare;
    }
}

