/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.spill;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.google.common.annotations.VisibleForTesting;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpillLocationVerifier {
    private static final Logger logger = LoggerFactory.getLogger(SpillLocationVerifier.class);
    private final AmazonS3 amazons3;
    private String bucket;
    private BucketState state;

    public SpillLocationVerifier(AmazonS3 amazons3) {
        this.amazons3 = amazons3;
        this.bucket = null;
        this.state = BucketState.UNCHECKED;
    }

    public void checkBucketAuthZ(String spillBucket) {
        if (spillBucket == null || spillBucket.equals("")) {
            return;
        }
        if (this.bucket == null || !this.bucket.equals(spillBucket)) {
            logger.info("Spill bucket has been changed from {} to {}", (Object)this.bucket, (Object)spillBucket);
            this.bucket = spillBucket;
            this.state = BucketState.UNCHECKED;
        }
        if (this.state == BucketState.UNCHECKED) {
            this.updateBucketState();
        }
        this.passOrFail();
    }

    @VisibleForTesting
    void updateBucketState() {
        try {
            Set buckets = this.amazons3.listBuckets().stream().map(b -> b.getName()).collect(Collectors.toSet());
            this.state = !buckets.contains(this.bucket) ? BucketState.INVALID : BucketState.VALID;
            logger.info("The state of bucket {} has been updated to {} from {}", new Object[]{this.bucket, this.state, BucketState.UNCHECKED});
        }
        catch (AmazonS3Exception ex) {
            throw new RuntimeException("Error while checking bucket ownership for " + this.bucket, ex);
        }
    }

    @VisibleForTesting
    void passOrFail() {
        switch (this.state) {
            case UNCHECKED: {
                throw new RuntimeException("Bucket state should have been checked already.");
            }
            case INVALID: {
                throw new RuntimeException("You do NOT own the spill bucket with the name: " + this.bucket);
            }
        }
    }

    private static enum BucketState {
        UNCHECKED,
        VALID,
        INVALID;

    }
}

