/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.ThrottlingInvoker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.SupportedTypes;
import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocationVerifier;
import com.amazonaws.athena.connector.lambda.handlers.AthenaExceptionFilter;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.request.PingResponse;
import com.amazonaws.athena.connector.lambda.security.CachableSecretsManager;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.KmsKeyFactory;
import com.amazonaws.athena.connector.lambda.security.LocalKeyFactory;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.amazonaws.services.kms.AWSKMS;
import com.amazonaws.services.kms.AWSKMSClientBuilder;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestStreamHandler;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManagerClientBuilder;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataHandler
implements RequestStreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(MetadataHandler.class);
    private static final String PARTITION_ID_COL = "partitionId";
    private static final String DISABLE_ENCRYPTION = "true";
    private static final String DEFAULT_SPILL_PREFIX = "athena-federation-spill";
    protected static final String SPILL_BUCKET_ENV = "spill_bucket";
    protected static final String SPILL_PREFIX_ENV = "spill_prefix";
    protected static final String KMS_KEY_ID_ENV = "kms_key_id";
    protected static final String DISABLE_SPILL_ENCRYPTION = "disable_spill_encryption";
    private final CachableSecretsManager secretsManager;
    private final AmazonAthena athena;
    private final ThrottlingInvoker athenaInvoker = ThrottlingInvoker.newDefaultBuilder(AthenaExceptionFilter.ATHENA_EXCEPTION_FILTER).build();
    private final EncryptionKeyFactory encryptionKeyFactory;
    private final String spillBucket;
    private final String spillPrefix;
    private final String sourceType;
    private final SpillLocationVerifier verifier;

    public MetadataHandler(String sourceType) {
        this.sourceType = sourceType;
        this.spillBucket = System.getenv(SPILL_BUCKET_ENV);
        String string = this.spillPrefix = System.getenv(SPILL_PREFIX_ENV) == null ? DEFAULT_SPILL_PREFIX : System.getenv(SPILL_PREFIX_ENV);
        this.encryptionKeyFactory = System.getenv(DISABLE_SPILL_ENCRYPTION) == null || !DISABLE_ENCRYPTION.equalsIgnoreCase(System.getenv(DISABLE_SPILL_ENCRYPTION)) ? (System.getenv(KMS_KEY_ID_ENV) != null ? new KmsKeyFactory((AWSKMS)AWSKMSClientBuilder.standard().build(), System.getenv(KMS_KEY_ID_ENV)) : new LocalKeyFactory()) : null;
        this.secretsManager = new CachableSecretsManager(AWSSecretsManagerClientBuilder.defaultClient());
        this.athena = AmazonAthenaClientBuilder.defaultClient();
        this.verifier = new SpillLocationVerifier((AmazonS3)AmazonS3ClientBuilder.standard().build());
    }

    public MetadataHandler(EncryptionKeyFactory encryptionKeyFactory, AWSSecretsManager secretsManager, AmazonAthena athena, String sourceType, String spillBucket, String spillPrefix) {
        this.encryptionKeyFactory = encryptionKeyFactory;
        this.secretsManager = new CachableSecretsManager(secretsManager);
        this.athena = athena;
        this.sourceType = sourceType;
        this.spillBucket = spillBucket;
        this.spillPrefix = spillPrefix;
        this.verifier = new SpillLocationVerifier((AmazonS3)AmazonS3ClientBuilder.standard().build());
    }

    protected String resolveSecrets(String rawString) {
        return this.secretsManager.resolveSecrets(rawString);
    }

    protected String getSecret(String secretName) {
        return this.secretsManager.getSecret(secretName);
    }

    protected EncryptionKey makeEncryptionKey() {
        return this.encryptionKeyFactory != null ? this.encryptionKeyFactory.create() : null;
    }

    protected SpillLocation makeSpillLocation(MetadataRequest request) {
        return S3SpillLocation.newBuilder().withBucket(this.spillBucket).withPrefix(this.spillPrefix).withQueryId(request.getQueryId()).withSplitId(UUID.randomUUID().toString()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void handleRequest(InputStream inputStream, OutputStream outputStream, Context context) throws IOException {
        try (BlockAllocatorImpl allocator = new BlockAllocatorImpl();){
            ObjectMapper objectMapper = VersionedObjectMapperFactory.create(allocator);
            try {
                Throwable throwable;
                FederationRequest rawReq;
                block47: {
                    block49: {
                        rawReq = (FederationRequest)objectMapper.readValue(inputStream, FederationRequest.class);
                        throwable = null;
                        if (!(rawReq instanceof PingRequest)) break block47;
                        try (PingResponse response = this.doPing((PingRequest)rawReq);){
                            this.assertNotNull(response);
                            objectMapper.writeValue(outputStream, (Object)response);
                        }
                        if (rawReq == null) return;
                        if (throwable == null) break block49;
                        try {
                            rawReq.close();
                            return;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                            return;
                        }
                    }
                    rawReq.close();
                    return;
                }
                try {
                    if (!(rawReq instanceof MetadataRequest)) {
                        throw new RuntimeException("Expected a MetadataRequest but found " + rawReq.getClass());
                    }
                    this.doHandleRequest(allocator, objectMapper, (MetadataRequest)rawReq, outputStream);
                    return;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
                finally {
                    if (rawReq != null) {
                        if (throwable != null) {
                            try {
                                rawReq.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rawReq.close();
                        }
                    }
                }
            }
            catch (Exception ex) {
                RuntimeException runtimeException;
                logger.warn("handleRequest: Completed with an exception.", (Throwable)ex);
                if (ex instanceof RuntimeException) {
                    runtimeException = (RuntimeException)ex;
                    throw runtimeException;
                }
                runtimeException = new RuntimeException(ex);
                throw runtimeException;
            }
        }
    }

    protected final void doHandleRequest(BlockAllocator allocator, ObjectMapper objectMapper, MetadataRequest req, OutputStream outputStream) throws Exception {
        logger.info("doHandleRequest: request[{}]", (Object)req);
        MetadataRequestType type = req.getRequestType();
        switch (type) {
            case LIST_SCHEMAS: {
                try (ListSchemasResponse response = this.doListSchemaNames(allocator, (ListSchemasRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
            case LIST_TABLES: {
                try (ListTablesResponse response = this.doListTables(allocator, (ListTablesRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
            case GET_TABLE: {
                try (GetTableResponse response = this.doGetTable(allocator, (GetTableRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    this.assertTypes(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
            case GET_TABLE_LAYOUT: {
                try (GetTableLayoutResponse response = this.doGetTableLayout(allocator, (GetTableLayoutRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
            case GET_SPLITS: {
                this.verifier.checkBucketAuthZ(this.spillBucket);
                try (GetSplitsResponse response = this.doGetSplits(allocator, (GetSplitsRequest)req);){
                    logger.info("doHandleRequest: response[{}]", (Object)response);
                    this.assertNotNull(response);
                    objectMapper.writeValue(outputStream, (Object)response);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unknown request type " + (Object)((Object)type));
    }

    public abstract ListSchemasResponse doListSchemaNames(BlockAllocator var1, ListSchemasRequest var2) throws Exception;

    public abstract ListTablesResponse doListTables(BlockAllocator var1, ListTablesRequest var2) throws Exception;

    public abstract GetTableResponse doGetTable(BlockAllocator var1, GetTableRequest var2) throws Exception;

    /*
     * Exception decompiling
     */
    public GetTableLayoutResponse doGetTableLayout(BlockAllocator allocator, GetTableLayoutRequest request) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void enhancePartitionSchema(SchemaBuilder partitionSchemaBuilder, GetTableLayoutRequest request) {
    }

    public abstract void getPartitions(BlockWriter var1, GetTableLayoutRequest var2, QueryStatusChecker var3) throws Exception;

    public abstract GetSplitsResponse doGetSplits(BlockAllocator var1, GetSplitsRequest var2) throws Exception;

    public PingResponse doPing(PingRequest request) {
        PingResponse response = new PingResponse(request.getCatalogName(), request.getQueryId(), this.sourceType, 24, 2);
        try {
            this.onPing(request);
        }
        catch (Exception ex) {
            logger.warn("doPing: encountered an exception while delegating onPing.", (Throwable)ex);
        }
        return response;
    }

    public void onPing(PingRequest request) {
    }

    private void assertNotNull(FederationResponse response) {
        if (response == null) {
            throw new RuntimeException("Response was null");
        }
    }

    private void assertTypes(GetTableResponse response) {
        for (Field next : response.getSchema().getFields()) {
            SupportedTypes.assertSupported(next);
        }
    }
}

