/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata;

import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;

public class ListTablesRequest
extends MetadataRequest {
    public static final int UNLIMITED_PAGE_SIZE_VALUE = -1;
    private final String schemaName;
    private final String nextToken;
    private final int pageSize;

    @JsonCreator
    public ListTablesRequest(@JsonProperty(value="identity") FederatedIdentity identity, @JsonProperty(value="queryId") String queryId, @JsonProperty(value="catalogName") String catalogName, @JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="nextToken") String nextToken, @JsonProperty(value="pageSize") int pageSize) {
        super(identity, MetadataRequestType.LIST_TABLES, queryId, catalogName);
        this.schemaName = schemaName;
        this.nextToken = nextToken;
        this.pageSize = pageSize;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void close() throws Exception {
    }

    public String toString() {
        return "ListTablesRequest{queryId=" + this.getQueryId() + ", schemaName='" + this.schemaName + '\'' + ", nextToken='" + this.nextToken + '\'' + ", pageSize=" + this.pageSize + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListTablesRequest that = (ListTablesRequest)o;
        return Objects.equal((Object)this.schemaName, (Object)that.schemaName) && Objects.equal((Object)((Object)this.getRequestType()), (Object)((Object)that.getRequestType())) && Objects.equal((Object)this.getCatalogName(), (Object)that.getCatalogName()) && Objects.equal((Object)this.getNextToken(), (Object)that.getNextToken()) && Objects.equal((Object)this.getPageSize(), (Object)that.getPageSize());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.schemaName, this.getRequestType(), this.getCatalogName(), this.getNextToken(), this.getPageSize()});
    }
}

