/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import java.time.ZoneId;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;

public enum DefaultGlueType {
    INT("int", Types.MinorType.INT.getType()),
    VARCHAR("varchar", Types.MinorType.VARCHAR.getType()),
    STRING("string", Types.MinorType.VARCHAR.getType()),
    BIGINT("bigint", Types.MinorType.BIGINT.getType()),
    DOUBLE("double", Types.MinorType.FLOAT8.getType()),
    FLOAT("float", Types.MinorType.FLOAT4.getType()),
    SMALLINT("smallint", Types.MinorType.SMALLINT.getType()),
    TINYINT("tinyint", Types.MinorType.TINYINT.getType()),
    BIT("boolean", Types.MinorType.BIT.getType()),
    VARBINARY("binary", Types.MinorType.VARBINARY.getType()),
    TIMESTAMP("timestamp", Types.MinorType.DATEMILLI.getType()),
    TIMESTAMPMILLITZ("timestamptz", (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, ZoneId.systemDefault().getId())),
    DATE("date", Types.MinorType.DATEDAY.getType());

    private static final Map<String, DefaultGlueType> TYPE_MAP;
    private static final Set<String> NON_COMPARABALE_SET;
    private String id;
    private ArrowType arrowType;

    private DefaultGlueType(String id, ArrowType arrowType) {
        this.id = id;
        this.arrowType = arrowType;
    }

    public static DefaultGlueType fromId(String id) {
        DefaultGlueType result = TYPE_MAP.get(id.toLowerCase());
        if (result == null) {
            throw new IllegalArgumentException("Unknown DefaultGlueType for id: " + id);
        }
        return result;
    }

    public static ArrowType toArrowType(String id) {
        DefaultGlueType result = TYPE_MAP.get(id.toLowerCase());
        if (result == null) {
            return null;
        }
        return result.getArrowType();
    }

    public ArrowType getArrowType() {
        return this.arrowType;
    }

    public static Set<String> getNonComparableSet() {
        return NON_COMPARABALE_SET;
    }

    static {
        TYPE_MAP = new HashMap<String, DefaultGlueType>();
        NON_COMPARABALE_SET = new HashSet<String>();
        for (DefaultGlueType next : DefaultGlueType.values()) {
            TYPE_MAP.put(next.id, next);
        }
        NON_COMPARABALE_SET.add(TIMESTAMPMILLITZ.name());
    }
}

