/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import com.amazonaws.athena.connector.lambda.data.FieldBuilder;
import com.amazonaws.athena.connector.lambda.metadata.glue.DefaultGlueType;
import com.amazonaws.athena.connector.lambda.metadata.glue.GlueTypeParser;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueFieldLexer {
    private static final Logger logger = LoggerFactory.getLogger(GlueFieldLexer.class);
    private static final String STRUCT = "struct";
    private static final String LIST = "array";
    private static final BaseTypeMapper DEFAULT_TYPE_MAPPER = type -> DefaultGlueType.toArrowType(type);

    private GlueFieldLexer() {
    }

    public static Field lex(String name, String input) {
        ArrowType typeResult = DEFAULT_TYPE_MAPPER.getType(input);
        if (typeResult != null) {
            return FieldBuilder.newBuilder(name, typeResult).build();
        }
        GlueTypeParser parser = new GlueTypeParser(input);
        return GlueFieldLexer.lexComplex(name, parser.next(), parser, DEFAULT_TYPE_MAPPER);
    }

    public static Field lex(String name, String input, BaseTypeMapper mapper) {
        Field result = mapper.getField(name, input);
        if (result != null) {
            return result;
        }
        GlueTypeParser parser = new GlueTypeParser(input);
        return GlueFieldLexer.lexComplex(name, parser.next(), parser, mapper);
    }

    private static Field lexComplex(String name, GlueTypeParser.Token startToken, GlueTypeParser parser, BaseTypeMapper mapper) {
        FieldBuilder fieldBuilder;
        logger.debug("lexComplex: enter - {}", (Object)name);
        if (startToken.getMarker() != GlueTypeParser.FIELD_START) {
            throw new RuntimeException("Parse error, expected " + GlueTypeParser.FIELD_START + " but found " + startToken.getMarker());
        }
        if (startToken.getValue().toLowerCase().equals(STRUCT)) {
            fieldBuilder = FieldBuilder.newBuilder(name, Types.MinorType.STRUCT.getType());
        } else {
            if (startToken.getValue().toLowerCase().equals(LIST)) {
                GlueTypeParser.Token arrayType = parser.next();
                String type = arrayType.getValue().toLowerCase();
                Field child = type.equals(STRUCT) || type.equals(LIST) ? GlueFieldLexer.lexComplex(name, arrayType, parser, mapper) : mapper.getField(name, arrayType.getValue());
                return FieldBuilder.newBuilder(name, Types.MinorType.LIST.getType()).addField(child).build();
            }
            throw new RuntimeException("Unexpected start type " + startToken.getValue());
        }
        while (parser.hasNext() && parser.currentToken().getMarker() != GlueTypeParser.FIELD_END) {
            Field child = GlueFieldLexer.lex(parser.next(), parser, mapper);
            fieldBuilder.addField(child);
            if (Types.getMinorTypeForArrowType((ArrowType)child.getType()) != Types.MinorType.LIST) continue;
            parser.next();
        }
        parser.next();
        logger.debug("lexComplex: exit - {}", (Object)name);
        return fieldBuilder.build();
    }

    private static Field lex(GlueTypeParser.Token startToken, GlueTypeParser parser, BaseTypeMapper mapper) {
        GlueTypeParser.Token nameToken = startToken;
        logger.debug("lex: enter - {}", (Object)nameToken.getValue());
        if (!nameToken.getMarker().equals(GlueTypeParser.FIELD_DIV)) {
            throw new RuntimeException("Expected Field DIV but found " + nameToken.getMarker() + " while processing " + nameToken.getValue());
        }
        String name = nameToken.getValue();
        GlueTypeParser.Token typeToken = parser.next();
        if (typeToken.getMarker().equals(GlueTypeParser.FIELD_START)) {
            logger.debug("lex: exit - {}", (Object)nameToken.getValue());
            return GlueFieldLexer.lexComplex(name, typeToken, parser, mapper);
        }
        if (typeToken.getMarker().equals(GlueTypeParser.FIELD_SEP) || typeToken.getMarker().equals(GlueTypeParser.FIELD_END)) {
            logger.debug("lex: exit - {}", (Object)nameToken.getValue());
            return mapper.getField(name, typeToken.getValue());
        }
        throw new RuntimeException("Unexpected Token " + typeToken.getValue() + "[" + typeToken.getMarker() + "] @ " + typeToken.getPos() + " while processing " + name);
    }

    public static interface BaseTypeMapper {
        public ArrowType getType(String var1);

        default public Field getField(String name, String type) {
            if (this.getType(type) != null) {
                return FieldBuilder.newBuilder(name, this.getType(type)).build();
            }
            return null;
        }
    }
}

