/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.RecordBatchSerDe;
import com.amazonaws.athena.connector.lambda.security.BlockCrypto;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.arrow.vector.types.pojo.Schema;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AesGcmBlockCrypto
implements BlockCrypto {
    protected static final int GCM_TAG_LENGTH_BITS = 128;
    protected static final int NONCE_BYTES = 12;
    protected static final int KEY_BYTES = 16;
    protected static final String KEYSPEC = "AES";
    protected static final String ALGO = "AES/GCM/NoPadding";
    protected static final String ALGO_BC = "BC";
    private final RecordBatchSerDe serDe;
    private final BlockAllocator allocator;

    public AesGcmBlockCrypto(BlockAllocator allocator) {
        this.serDe = new RecordBatchSerDe(allocator);
        this.allocator = allocator;
    }

    @Override
    public byte[] encrypt(EncryptionKey key, Block block) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.serDe.serialize(block.getRecordBatch(), out);
            Cipher cipher = this.makeCipher(1, key);
            return cipher.doFinal(out.toByteArray());
        }
        catch (IOException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public Block decrypt(EncryptionKey key, byte[] bytes, Schema schema) {
        try {
            Cipher cipher = this.makeCipher(2, key);
            byte[] clear = cipher.doFinal(bytes);
            Block resultBlock = this.allocator.createBlock(schema);
            resultBlock.loadRecordBatch(this.serDe.deserialize(clear));
            return resultBlock;
        }
        catch (IOException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public byte[] decrypt(EncryptionKey key, byte[] bytes) {
        try {
            Cipher cipher = this.makeCipher(2, key);
            return cipher.doFinal(bytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Cipher makeCipher(int mode, EncryptionKey key) {
        if (key.getNonce().length != 12) {
            throw new RuntimeException("Expected 12 nonce bytes but found " + key.getNonce().length);
        }
        if (key.getKey().length != 16) {
            throw new RuntimeException("Expected 16 key bytes but found " + key.getKey().length);
        }
        GCMParameterSpec spec = new GCMParameterSpec(128, key.getNonce());
        SecretKeySpec secretKeySpec = new SecretKeySpec(key.getKey(), KEYSPEC);
        try {
            Cipher cipher = Cipher.getInstance(ALGO, ALGO_BC);
            cipher.init(mode, (Key)secretKeySpec, spec);
            return cipher;
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

