/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class BaseDeserializer<T>
extends StdDeserializer<T> {
    protected BaseDeserializer(Class<T> clazz) {
        super(clazz);
    }

    public T deserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
        if (jparser.nextToken() != JsonToken.VALUE_NULL) {
            this.validateObjectStart(jparser.getCurrentToken());
            T result = this.doDeserialize(jparser, ctxt);
            this.validateObjectEnd(jparser);
            return result;
        }
        return null;
    }

    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(jp, ctxt);
    }

    protected abstract T doDeserialize(JsonParser var1, DeserializationContext var2) throws IOException;

    protected String getNextStringField(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        jparser.nextToken();
        return jparser.getValueAsString();
    }

    protected boolean getNextBoolField(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        jparser.nextToken();
        return jparser.getValueAsBoolean();
    }

    protected byte[] getNextBinaryField(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        jparser.nextToken();
        return jparser.getBinaryValue();
    }

    protected int getNextIntField(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        jparser.nextToken();
        return jparser.getValueAsInt();
    }

    protected void writeStringArray(JsonGenerator jgen, String fieldname, Collection<String> values) throws IOException {
        jgen.writeArrayFieldStart(fieldname);
        for (String nextElement : values) {
            jgen.writeString(nextElement);
        }
        jgen.writeEndArray();
    }

    protected List<String> getNextStringArray(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        this.validateArrayStart(jparser);
        ArrayList<String> result = new ArrayList<String>();
        while (jparser.nextToken() != JsonToken.END_ARRAY) {
            result.add(jparser.getValueAsString());
        }
        return result;
    }

    protected Map<String, String> getNextStringMap(JsonParser jparser, String expectedFieldName) throws IOException {
        this.assertFieldName(jparser, expectedFieldName);
        this.validateObjectStart(jparser);
        HashMap<String, String> result = new HashMap<String, String>();
        while (jparser.nextToken() != JsonToken.END_OBJECT) {
            result.put(jparser.getCurrentName(), jparser.getValueAsString());
        }
        return result;
    }

    protected void assertFieldName(JsonParser jparser, String expectedFieldName) throws IOException {
        jparser.nextToken();
        if (jparser.getCurrentToken() != JsonToken.FIELD_NAME) {
            throw new IllegalStateException("Expected field name token but got " + jparser.getCurrentToken());
        }
        String fieldNameToken = jparser.getCurrentName();
        if (expectedFieldName != null && !expectedFieldName.equals(fieldNameToken)) {
            throw new IllegalStateException("Unexpected field[" + fieldNameToken + "] while expecting[" + expectedFieldName + "]");
        }
    }

    protected void validateObjectStart(JsonToken token) throws IOException {
        if (!JsonToken.START_OBJECT.equals((Object)token)) {
            throw new IllegalStateException("Expected " + JsonToken.START_OBJECT + " found " + token.asString());
        }
    }

    protected void validateObjectEnd(JsonParser jparser) throws IOException {
        if (!JsonToken.END_OBJECT.equals((Object)jparser.nextToken())) {
            throw new IllegalStateException("Expected " + JsonToken.END_OBJECT + " found " + jparser.getText());
        }
    }

    protected void validateArrayStart(JsonParser jparser) throws IOException {
        if (!JsonToken.START_ARRAY.equals((Object)jparser.nextToken())) {
            throw new IllegalStateException("Expected " + JsonToken.START_ARRAY + " found " + jparser.getText());
        }
    }

    protected void validateObjectStart(JsonParser jparser) throws IOException {
        if (!JsonToken.START_OBJECT.equals((Object)jparser.nextToken())) {
            throw new IllegalStateException("Expected " + JsonToken.START_OBJECT + " found " + jparser.getText());
        }
    }

    protected String getType(JsonParser jparser) throws IOException {
        this.assertFieldName(jparser, "@type");
        jparser.nextToken();
        return jparser.getValueAsString();
    }

    protected void ignoreRestOfObject(JsonParser jparser) throws IOException {
        if (jparser.getCurrentToken() == JsonToken.END_OBJECT) {
            return;
        }
        int open = 1;
        while (true) {
            JsonToken t;
            if ((t = jparser.nextToken()) == null) {
                throw new IllegalStateException("Expected " + JsonToken.END_OBJECT + " found " + jparser.getText());
            }
            if (t.isStructStart()) {
                ++open;
                continue;
            }
            if (t == JsonToken.END_OBJECT && --open == 0) break;
        }
    }
}

