/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;

public abstract class BaseSerializer<T>
extends StdSerializer<T> {
    static final String TYPE_FIELD = "@type";

    protected BaseSerializer(Class<T> clazz) {
        super(clazz);
    }

    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value != null) {
            jgen.writeStartObject();
            this.doSerialize(value, jgen, provider);
            jgen.writeEndObject();
        } else {
            jgen.writeNull();
        }
    }

    public void serializeWithType(T value, JsonGenerator gen, SerializerProvider serializers, TypeSerializer typeSer) throws IOException {
        this.serialize(value, gen, serializers);
    }

    protected abstract void doSerialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected void writeStringArray(JsonGenerator jgen, String fieldName, Collection<String> values) throws IOException {
        jgen.writeArrayFieldStart(fieldName);
        for (String nextElement : values) {
            jgen.writeString(nextElement);
        }
        jgen.writeEndArray();
    }

    protected void writeStringMap(JsonGenerator jgen, String fieldName, Map<String, String> values) throws IOException {
        jgen.writeObjectFieldStart(fieldName);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            jgen.writeStringField(entry.getKey(), entry.getValue());
        }
        jgen.writeEndObject();
    }

    void writeType(JsonGenerator jgen, Class<?> type) throws IOException {
        jgen.writeStringField(TYPE_FIELD, type.getSimpleName());
    }
}

