/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class DelegatingSerializer<T>
extends BaseSerializer<T> {
    private final Map<String, TypedSerializer<T>> delegateSerDeMap;

    public DelegatingSerializer(Class<T> clazz, Set<TypedSerializer<T>> serDes) {
        super(clazz);
        ImmutableMap.Builder delegateSerDeMapBuilder = ImmutableMap.builder();
        for (TypedSerializer<T> serDe : serDes) {
            delegateSerDeMapBuilder.put((Object)serDe.getSubType().getSimpleName(), serDe);
        }
        this.delegateSerDeMap = delegateSerDeMapBuilder.build();
    }

    @Override
    public void doSerialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        String type = value.getClass().getSimpleName();
        TypedSerializer<T> delegateSerDe = this.delegateSerDeMap.get(type);
        if (delegateSerDe == null) {
            throw new IllegalStateException("No SerDe configured for " + type);
        }
        delegateSerDe.doSerialize(value, jgen, provider);
    }

    public Map<String, TypedSerializer<T>> getDelegateSerDeMap() {
        return this.delegateSerDeMap;
    }
}

