/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.serde.DelegatingDeserializer;
import com.amazonaws.athena.connector.lambda.serde.DelegatingSerializer;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.Collection;
import org.apache.arrow.vector.types.DateUnit;
import org.apache.arrow.vector.types.FloatingPointPrecision;
import org.apache.arrow.vector.types.IntervalUnit;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.UnionMode;
import org.apache.arrow.vector.types.pojo.ArrowType;

final class ArrowTypeSerDe {
    private ArrowTypeSerDe() {
    }

    private static final class IntervalSerDe {
        private static final String UNIT_FIELD = "unit";

        private IntervalSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Interval.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                IntervalUnit unit = IntervalUnit.valueOf((String)this.getNextStringField(jparser, IntervalSerDe.UNIT_FIELD));
                return new ArrowType.Interval(unit);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Interval.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Interval interval = (ArrowType.Interval)arrowType;
                jgen.writeStringField(IntervalSerDe.UNIT_FIELD, interval.getUnit().toString());
            }
        }
    }

    private static final class TimeStampSerDe {
        private static final String UNIT_FIELD = "unit";
        private static final String TIMEZONE_FIELD = "timezone";

        private TimeStampSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Timestamp.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                TimeUnit unit = TimeUnit.valueOf((String)this.getNextStringField(jparser, TimeStampSerDe.UNIT_FIELD));
                String timezone = this.getNextStringField(jparser, TimeStampSerDe.TIMEZONE_FIELD);
                return new ArrowType.Timestamp(unit, timezone);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Timestamp.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Timestamp timestamp = (ArrowType.Timestamp)arrowType;
                jgen.writeStringField(TimeStampSerDe.UNIT_FIELD, timestamp.getUnit().toString());
                jgen.writeStringField(TimeStampSerDe.TIMEZONE_FIELD, timestamp.getTimezone());
            }
        }
    }

    private static final class TimeSerDe {
        private static final String UNIT_FIELD = "unit";
        private static final String BIT_WIDTH_FIELD = "bitWidth";

        private TimeSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Time.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                TimeUnit unit = TimeUnit.valueOf((String)this.getNextStringField(jparser, TimeSerDe.UNIT_FIELD));
                int bitWidth = this.getNextIntField(jparser, TimeSerDe.BIT_WIDTH_FIELD);
                return new ArrowType.Time(unit, bitWidth);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Time.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Time time = (ArrowType.Time)arrowType;
                jgen.writeStringField(TimeSerDe.UNIT_FIELD, time.getUnit().toString());
                jgen.writeNumberField(TimeSerDe.BIT_WIDTH_FIELD, time.getBitWidth());
            }
        }
    }

    private static final class DateSerDe {
        private static final String UNIT_FIELD = "unit";

        private DateSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Date.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                DateUnit unit = DateUnit.valueOf((String)this.getNextStringField(jparser, DateSerDe.UNIT_FIELD));
                return new ArrowType.Date(unit);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Date.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Date date = (ArrowType.Date)arrowType;
                jgen.writeStringField(DateSerDe.UNIT_FIELD, date.getUnit().toString());
            }
        }
    }

    private static final class DecimalSerDe {
        private static final String PRECISION_FIELD = "precision";
        private static final String SCALE_FIELD = "scale";

        private DecimalSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Decimal.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                int precision = this.getNextIntField(jparser, DecimalSerDe.PRECISION_FIELD);
                int scale = this.getNextIntField(jparser, DecimalSerDe.SCALE_FIELD);
                return new ArrowType.Decimal(precision, scale);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Decimal.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Decimal decimal = (ArrowType.Decimal)arrowType;
                jgen.writeNumberField(DecimalSerDe.PRECISION_FIELD, decimal.getPrecision());
                jgen.writeNumberField(DecimalSerDe.SCALE_FIELD, decimal.getScale());
            }
        }
    }

    private static final class BoolSerDe {
        private BoolSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Bool.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.Bool();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Bool.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    private static final class FixedSizeBinarySerDe {
        private static final String BYTE_WIDTH_FIELD = "byteWidth";

        private FixedSizeBinarySerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.FixedSizeBinary.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                int byteWidth = this.getNextIntField(jparser, FixedSizeBinarySerDe.BYTE_WIDTH_FIELD);
                return new ArrowType.FixedSizeBinary(byteWidth);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.FixedSizeBinary.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.FixedSizeBinary fixedSizeBinary = (ArrowType.FixedSizeBinary)arrowType;
                jgen.writeNumberField(FixedSizeBinarySerDe.BYTE_WIDTH_FIELD, fixedSizeBinary.getByteWidth());
            }
        }
    }

    private static final class BinarySerDe {
        private BinarySerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Binary.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.Binary();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Binary.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    private static final class Utf8SerDe {
        private Utf8SerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Utf8.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.Utf8();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Utf8.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    private static final class FloatingPointSerDe {
        private static final String PRECISION_FIELD = "precision";

        private FloatingPointSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.FloatingPoint.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                FloatingPointPrecision precision = FloatingPointPrecision.valueOf((String)this.getNextStringField(jparser, FloatingPointSerDe.PRECISION_FIELD));
                return new ArrowType.FloatingPoint(precision);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.FloatingPoint.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.FloatingPoint floatingPoint = (ArrowType.FloatingPoint)arrowType;
                jgen.writeStringField(FloatingPointSerDe.PRECISION_FIELD, floatingPoint.getPrecision().toString());
            }
        }
    }

    private static final class IntSerDe {
        private static final String BIT_WIDTH_FIELD = "bitWidth";
        private static final String IS_SIGNED_FIELD = "isSigned";

        private IntSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Int.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                int bitWidth = this.getNextIntField(jparser, IntSerDe.BIT_WIDTH_FIELD);
                boolean isSigned = this.getNextBoolField(jparser, IntSerDe.IS_SIGNED_FIELD);
                return new ArrowType.Int(bitWidth, isSigned);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Int.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Int arrowInt = (ArrowType.Int)arrowType;
                jgen.writeNumberField(IntSerDe.BIT_WIDTH_FIELD, arrowInt.getBitWidth());
                jgen.writeBooleanField(IntSerDe.IS_SIGNED_FIELD, arrowInt.getIsSigned());
            }
        }
    }

    private static final class UnionSerDe {
        private static final String MODE_FIELD = "mode";
        private static final String TYPE_IDS_FIELD = "typeIds";

        private UnionSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Union.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                UnionMode mode = UnionMode.valueOf((String)this.getNextStringField(jparser, UnionSerDe.MODE_FIELD));
                this.assertFieldName(jparser, UnionSerDe.TYPE_IDS_FIELD);
                ImmutableList.Builder typeIds = ImmutableList.builder();
                while (jparser.nextToken() != JsonToken.END_ARRAY) {
                    typeIds.add((Object)jparser.getValueAsInt());
                }
                return new ArrowType.Union(mode, Ints.toArray((Collection)typeIds.build()));
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Union.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.Union union = (ArrowType.Union)arrowType;
                jgen.writeStringField(UnionSerDe.MODE_FIELD, union.toString());
                jgen.writeArrayFieldStart(UnionSerDe.TYPE_IDS_FIELD);
                for (int typeId : union.getTypeIds()) {
                    jgen.writeNumber(typeId);
                }
                jgen.writeEndArray();
            }
        }
    }

    private static final class FixedSizeListSerDe {
        private static final String LIST_SIZE_FIELD = "listSize";

        private FixedSizeListSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.FixedSizeList.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                int listSize = this.getNextIntField(jparser, FixedSizeListSerDe.LIST_SIZE_FIELD);
                return new ArrowType.FixedSizeList(listSize);
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.FixedSizeList.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
                ArrowType.FixedSizeList fixedSizeList = (ArrowType.FixedSizeList)arrowType;
                jgen.writeNumberField(FixedSizeListSerDe.LIST_SIZE_FIELD, fixedSizeList.getListSize());
            }
        }
    }

    private static final class ListSerDe {
        private ListSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.List.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.List();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.List.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    private static final class StructSerDe {
        private StructSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Struct.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.Struct();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Struct.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    private static final class NullSerDe {
        private NullSerDe() {
        }

        private static final class Deserializer
        extends TypedDeserializer<ArrowType> {
            private Deserializer() {
                super(ArrowType.class, ArrowType.Null.class);
            }

            @Override
            protected ArrowType doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
                return new ArrowType.Null();
            }
        }

        private static final class Serializer
        extends TypedSerializer<ArrowType> {
            private Serializer() {
                super(ArrowType.class, ArrowType.Null.class);
            }

            @Override
            protected void doTypedSerialize(ArrowType arrowType, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            }
        }
    }

    static final class Deserializer
    extends DelegatingDeserializer<ArrowType> {
        Deserializer() {
            super(ArrowType.class, ImmutableSet.builder().add((Object)new NullSerDe.Deserializer()).add((Object)new StructSerDe.Deserializer()).add((Object)new ListSerDe.Deserializer()).add((Object)new FixedSizeListSerDe.Deserializer()).add((Object)new UnionSerDe.Deserializer()).add((Object)new IntSerDe.Deserializer()).add((Object)new FloatingPointSerDe.Deserializer()).add((Object)new Utf8SerDe.Deserializer()).add((Object)new BinarySerDe.Deserializer()).add((Object)new FixedSizeBinarySerDe.Deserializer()).add((Object)new BoolSerDe.Deserializer()).add((Object)new DecimalSerDe.Deserializer()).add((Object)new DateSerDe.Deserializer()).add((Object)new TimeSerDe.Deserializer()).add((Object)new TimeStampSerDe.Deserializer()).add((Object)new IntervalSerDe.Deserializer()).build());
        }
    }

    static final class Serializer
    extends DelegatingSerializer<ArrowType> {
        Serializer() {
            super(ArrowType.class, ImmutableSet.builder().add((Object)new NullSerDe.Serializer()).add((Object)new StructSerDe.Serializer()).add((Object)new ListSerDe.Serializer()).add((Object)new FixedSizeListSerDe.Serializer()).add((Object)new UnionSerDe.Serializer()).add((Object)new IntSerDe.Serializer()).add((Object)new FloatingPointSerDe.Serializer()).add((Object)new Utf8SerDe.Serializer()).add((Object)new BinarySerDe.Serializer()).add((Object)new FixedSizeBinarySerDe.Serializer()).add((Object)new BoolSerDe.Serializer()).add((Object)new DecimalSerDe.Serializer()).add((Object)new DateSerDe.Serializer()).add((Object)new TimeSerDe.Serializer()).add((Object)new TimeStampSerDe.Serializer()).add((Object)new IntervalSerDe.Serializer()).build());
        }
    }
}

