/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorRegistry;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.SchemaSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ReadChannel;
import org.apache.arrow.vector.ipc.WriteChannel;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.arrow.vector.ipc.message.MessageSerializer;
import org.apache.arrow.vector.types.pojo.Schema;

final class BlockSerDe {
    private static final String ALLOCATOR_ID_FIELD_NAME = "aId";
    private static final String SCHEMA_FIELD_NAME = "schema";
    private static final String BATCH_FIELD_NAME = "records";

    private BlockSerDe() {
    }

    static final class Deserializer
    extends BaseDeserializer<Block> {
        private final BlockAllocator allocator;
        private final BlockAllocatorRegistry allocatorRegistry;
        private SchemaSerDe.Deserializer schemaDeserializer;

        Deserializer(BlockAllocator allocator, SchemaSerDe.Deserializer schemaDeserializer) {
            super(Block.class);
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.allocator = allocator;
            this.allocatorRegistry = null;
        }

        Deserializer(BlockAllocatorRegistry allocatorRegistry, SchemaSerDe.Deserializer schemaDeserializer) {
            super(Block.class);
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.allocator = null;
            this.allocatorRegistry = Objects.requireNonNull(allocatorRegistry, "allocatorRegistry is null");
        }

        @Override
        protected Block doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String allocatorId = this.getNextStringField(jparser, BlockSerDe.ALLOCATOR_ID_FIELD_NAME);
            this.assertFieldName(jparser, BlockSerDe.SCHEMA_FIELD_NAME);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            byte[] batchBytes = this.getNextBinaryField(jparser, BlockSerDe.BATCH_FIELD_NAME);
            Block block = this.getOrCreateAllocator(allocatorId).createBlock(schema);
            if (batchBytes.length > 0) {
                ArrowRecordBatch batch = this.deserializeBatch(allocatorId, batchBytes);
                block.loadRecordBatch(batch);
            }
            return block;
        }

        private BlockAllocator getOrCreateAllocator(String allocatorId) {
            if (this.allocator != null) {
                return this.allocator;
            }
            if (this.allocatorRegistry != null) {
                return this.allocatorRegistry.getOrCreateAllocator(allocatorId);
            }
            throw new IllegalStateException("allocator and allocatorRegistry are both null");
        }

        private ArrowRecordBatch deserializeBatch(String allocatorId, byte[] batchBytes) throws IOException {
            return this.deserializeRecordBatch(this.getOrCreateAllocator(allocatorId), batchBytes);
        }

        private ArrowRecordBatch deserializeRecordBatch(BlockAllocator allocator, byte[] in) {
            AtomicReference batch = new AtomicReference();
            try {
                return allocator.registerBatch(root -> {
                    batch.set((ArrowRecordBatch)MessageSerializer.deserializeMessageBatch((ReadChannel)new ReadChannel(Channels.newChannel(new ByteArrayInputStream(in))), (BufferAllocator)root));
                    return (ArrowRecordBatch)batch.get();
                });
            }
            catch (Exception ex) {
                if (batch.get() != null) {
                    ((ArrowRecordBatch)batch.get()).close();
                }
                throw ex;
            }
        }
    }

    static final class Serializer
    extends BaseSerializer<Block> {
        private SchemaSerDe.Serializer schemaSerializer;

        Serializer(SchemaSerDe.Serializer schemaSerializer) {
            super(Block.class);
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
        }

        @Override
        protected void doSerialize(Block block, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeStringField(BlockSerDe.ALLOCATOR_ID_FIELD_NAME, block.getAllocatorId());
            jgen.writeFieldName(BlockSerDe.SCHEMA_FIELD_NAME);
            this.schemaSerializer.serialize(block.getSchema(), jgen, provider);
            jgen.writeFieldName(BlockSerDe.BATCH_FIELD_NAME);
            if (block.getRowCount() > 0) {
                jgen.writeBinary(this.serializeRecordBatch(block.getRecordBatch()));
            } else {
                jgen.writeString("");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] serializeRecordBatch(ArrowRecordBatch recordBatch) throws IOException {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                MessageSerializer.serialize((WriteChannel)new WriteChannel(Channels.newChannel(out)), (ArrowRecordBatch)recordBatch);
                byte[] byArray = out.toByteArray();
                return byArray;
            }
            finally {
                recordBatch.close();
            }
        }
    }
}

