/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

final class EncryptionKeySerDe {
    private static final String KEY_FIELD = "key";
    private static final String NONCE_FIELD = "nonce";

    private EncryptionKeySerDe() {
    }

    static final class Deserializer
    extends BaseDeserializer<EncryptionKey> {
        Deserializer() {
            super(EncryptionKey.class);
        }

        @Override
        protected EncryptionKey doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            byte[] key = this.getNextBinaryField(jparser, EncryptionKeySerDe.KEY_FIELD);
            byte[] nonce = this.getNextBinaryField(jparser, EncryptionKeySerDe.NONCE_FIELD);
            return new EncryptionKey(key, nonce);
        }
    }

    static final class Serializer
    extends BaseSerializer<EncryptionKey> {
        Serializer() {
            super(EncryptionKey.class);
        }

        @Override
        protected void doSerialize(EncryptionKey encryptionKey, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeBinaryField(EncryptionKeySerDe.KEY_FIELD, encryptionKey.getKey());
            jgen.writeBinaryField(EncryptionKeySerDe.NONCE_FIELD, encryptionKey.getNonce());
        }
    }
}

