/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.predicate.EquatableValueSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.BlockSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

final class EquatableValueSetSerDe {
    private static final String VALUE_BLOCK_FIELD = "valueBlock";
    private static final String WHITELIST_FIELD = "whiteList";
    private static final String NULL_ALLOWED_FIELD = "nullAllowed";

    private EquatableValueSetSerDe() {
    }

    static final class Deserializer
    extends TypedDeserializer<ValueSet> {
        private final BlockSerDe.Deserializer blockDeserializer;

        Deserializer(BlockSerDe.Deserializer blockDeserializer) {
            super(ValueSet.class, EquatableValueSet.class);
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockSerDe is null");
        }

        @Override
        protected ValueSet doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, EquatableValueSetSerDe.VALUE_BLOCK_FIELD);
            Block valueBlock = (Block)this.blockDeserializer.deserialize(jparser, ctxt);
            boolean whiteList = this.getNextBoolField(jparser, EquatableValueSetSerDe.WHITELIST_FIELD);
            boolean nullAllowed = this.getNextBoolField(jparser, EquatableValueSetSerDe.NULL_ALLOWED_FIELD);
            return new EquatableValueSet(valueBlock, whiteList, nullAllowed);
        }
    }

    static final class Serializer
    extends TypedSerializer<ValueSet> {
        private final BlockSerDe.Serializer blockSerializer;

        Serializer(BlockSerDe.Serializer blockSerializer) {
            super(ValueSet.class, EquatableValueSet.class);
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerDe is null");
        }

        @Override
        protected void doTypedSerialize(ValueSet valueSet, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            EquatableValueSet equatableValueSet = (EquatableValueSet)valueSet;
            jgen.writeFieldName(EquatableValueSetSerDe.VALUE_BLOCK_FIELD);
            this.blockSerializer.serialize(equatableValueSet.getValueBlock(), jgen, provider);
            jgen.writeBooleanField(EquatableValueSetSerDe.WHITELIST_FIELD, equatableValueSet.isWhiteList());
            jgen.writeBooleanField(EquatableValueSetSerDe.NULL_ALLOWED_FIELD, equatableValueSet.nullAllowed);
        }
    }
}

