/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.BlockSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.ConstraintsSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestDeserializer;
import com.amazonaws.athena.connector.lambda.serde.v2.MetadataRequestSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

final class GetSplitsRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String PARTITIONS_FIELD = "partitions";
    private static final String PARTITION_COLS_FIELD = "partitionColumns";
    private static final String CONSTRAINTS_FIELD = "constraints";
    private static final String CONTINUATION_TOKEN_FIELD = "continuationToken";

    private GetSplitsRequestSerDe() {
    }

    static final class Deserializer
    extends MetadataRequestDeserializer {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;
        private final TableNameSerDe.Deserializer tableNameDeserializer;
        private final BlockSerDe.Deserializer blockDeserializer;
        private final ConstraintsSerDe.Deserializer constraintsDeserializer;

        Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer, TableNameSerDe.Deserializer tableNameDeserializer, BlockSerDe.Deserializer blockDeserializer, ConstraintsSerDe.Deserializer constraintsDeserializer) {
            super(GetSplitsRequest.class, identityDeserializer);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
            this.constraintsDeserializer = Objects.requireNonNull(constraintsDeserializer, "constraintsDeserializer is null");
        }

        @Override
        protected MetadataRequest doRequestDeserialize(JsonParser jparser, DeserializationContext ctxt, FederatedIdentity identity, String queryId, String catalogName) throws IOException {
            this.assertFieldName(jparser, GetSplitsRequestSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, GetSplitsRequestSerDe.PARTITIONS_FIELD);
            Block partitions = (Block)this.blockDeserializer.deserialize(jparser, ctxt);
            List<String> partitionColumns = this.getNextStringArray(jparser, GetSplitsRequestSerDe.PARTITION_COLS_FIELD);
            this.assertFieldName(jparser, GetSplitsRequestSerDe.CONSTRAINTS_FIELD);
            Constraints constraints = (Constraints)this.constraintsDeserializer.deserialize(jparser, ctxt);
            String continuationToken = this.getNextStringField(jparser, GetSplitsRequestSerDe.CONTINUATION_TOKEN_FIELD);
            return new GetSplitsRequest(identity, queryId, catalogName, tableName, partitions, partitionColumns, constraints, continuationToken);
        }
    }

    static final class Serializer
    extends MetadataRequestSerializer {
        private final FederatedIdentitySerDe.Serializer identitySerializer;
        private final TableNameSerDe.Serializer tableNameSerializer;
        private final BlockSerDe.Serializer blockSerializer;
        private final ConstraintsSerDe.Serializer constraintsSerializer;

        Serializer(FederatedIdentitySerDe.Serializer identitySerializer, TableNameSerDe.Serializer tableNameSerializer, BlockSerDe.Serializer blockSerializer, ConstraintsSerDe.Serializer constraintsSerializer) {
            super(GetSplitsRequest.class, identitySerializer);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerializer is null");
            this.constraintsSerializer = Objects.requireNonNull(constraintsSerializer, "constraintsSerializer is null");
        }

        @Override
        protected void doRequestSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            GetSplitsRequest getSplitsRequest = (GetSplitsRequest)federationRequest;
            jgen.writeFieldName(GetSplitsRequestSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(getSplitsRequest.getTableName(), jgen, provider);
            jgen.writeFieldName(GetSplitsRequestSerDe.PARTITIONS_FIELD);
            this.blockSerializer.serialize(getSplitsRequest.getPartitions(), jgen, provider);
            this.writeStringArray(jgen, GetSplitsRequestSerDe.PARTITION_COLS_FIELD, getSplitsRequest.getPartitionCols());
            jgen.writeFieldName(GetSplitsRequestSerDe.CONSTRAINTS_FIELD);
            this.constraintsSerializer.serialize(getSplitsRequest.getConstraints(), jgen, provider);
            jgen.writeStringField(GetSplitsRequestSerDe.CONTINUATION_TOKEN_FIELD, getSplitsRequest.getContinuationToken());
        }
    }
}

