/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LambdaFunctionExceptionSerDe {
    private static final Joiner COMMA_JOINER = Joiner.on((String)",");
    private static final String ERROR_TYPE_FIELD = "errorType";
    private static final String ERROR_MESSAGE_FIELD = "errorMessage";
    private static final String CAUSE_FIELD = "cause";
    private static final String STACK_TRACE_FIELD = "stackTrace";

    private LambdaFunctionExceptionSerDe() {
    }

    static final class Deserializer
    extends BaseDeserializer<LambdaFunctionException> {
        Deserializer() {
            super(LambdaFunctionException.class);
        }

        @Override
        public LambdaFunctionException deserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.validateObjectStart(jparser.getCurrentToken());
            return this.doDeserialize(jparser, ctxt);
        }

        @Override
        protected LambdaFunctionException doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            JsonNode root = (JsonNode)jparser.getCodec().readTree(jparser);
            return this.recursiveParse(root);
        }

        private LambdaFunctionException recursiveParse(JsonNode root) {
            String errorType = this.getNullableStringValue(root, LambdaFunctionExceptionSerDe.ERROR_TYPE_FIELD);
            String errorMessage = this.getNullableStringValue(root, LambdaFunctionExceptionSerDe.ERROR_MESSAGE_FIELD);
            LambdaFunctionException cause = null;
            JsonNode causeNode = root.get(LambdaFunctionExceptionSerDe.CAUSE_FIELD);
            if (causeNode != null) {
                cause = this.recursiveParse(causeNode);
            }
            LinkedList<List<String>> stackTraces = new LinkedList<List<String>>();
            JsonNode stackTraceNode = root.get(LambdaFunctionExceptionSerDe.STACK_TRACE_FIELD);
            if (stackTraceNode != null && stackTraceNode.isArray()) {
                Iterator elements = stackTraceNode.elements();
                while (elements.hasNext()) {
                    LinkedList<String> innerList = new LinkedList<String>();
                    JsonNode element = (JsonNode)elements.next();
                    if (element.isArray()) {
                        Iterator innerElements = element.elements();
                        while (innerElements.hasNext()) {
                            innerList.add(((JsonNode)innerElements.next()).asText());
                        }
                    } else {
                        innerList.add(element.asText());
                    }
                    stackTraces.add(innerList);
                }
            }
            try {
                Constructor constructor = LambdaFunctionException.class.getDeclaredConstructor(String.class, String.class, LambdaFunctionException.class, List.class);
                constructor.setAccessible(true);
                return (LambdaFunctionException)constructor.newInstance(errorType, errorMessage, cause, stackTraces);
            }
            catch (ReflectiveOperationException e) {
                return new LambdaFunctionException(this.appendStackTrace(errorMessage, stackTraces), false, errorType);
            }
        }

        private String getNullableStringValue(JsonNode parent, String field) {
            JsonNode child = parent.get(field);
            if (child != null) {
                return child.asText();
            }
            return null;
        }

        private String appendStackTrace(String errorMessage, List<List<String>> stackTraces) {
            return errorMessage + ". Stack trace: " + stackTraces;
        }
    }
}

