/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.BlockSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;

final class MarkerSerDe {
    private static final String VALUE_BLOCK_FIELD = "valueBlock";
    private static final String BOUND_FIELD = "bound";
    private static final String NULL_VALUE_FIELD = "nullValue";

    private MarkerSerDe() {
    }

    static final class Deserializer
    extends BaseDeserializer<Marker> {
        private final BlockSerDe.Deserializer blockDeserializer;

        Deserializer(BlockSerDe.Deserializer blockDeserializer) {
            super(Marker.class);
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
        }

        @Override
        protected Marker doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, MarkerSerDe.VALUE_BLOCK_FIELD);
            Block valueBlock = (Block)this.blockDeserializer.deserialize(jparser, ctxt);
            Marker.Bound bound = Marker.Bound.valueOf(this.getNextStringField(jparser, MarkerSerDe.BOUND_FIELD));
            boolean nullValue = this.getNextBoolField(jparser, MarkerSerDe.NULL_VALUE_FIELD);
            return new Marker(valueBlock, bound, nullValue);
        }
    }

    static final class Serializer
    extends BaseSerializer<Marker> {
        private final BlockSerDe.Serializer blockSerializer;

        Serializer(BlockSerDe.Serializer blockSerializer) {
            super(Marker.class);
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerializer is null");
        }

        @Override
        protected void doSerialize(Marker marker, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(MarkerSerDe.VALUE_BLOCK_FIELD);
            this.blockSerializer.serialize(marker.getValueBlock(), jgen, provider);
            jgen.writeStringField(MarkerSerDe.BOUND_FIELD, marker.getBound().toString());
            jgen.writeBooleanField(MarkerSerDe.NULL_VALUE_FIELD, marker.isNullValue());
        }
    }
}

