/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.records.ReadRecordsRequest;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.ConstraintsSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SchemaSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SplitSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.TableNameSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

final class ReadRecordsRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String QUERY_ID_FIELD = "queryId";
    private static final String CATALOG_NAME_FIELD = "catalogName";
    private static final String TABLE_NAME_FIELD = "tableName";
    private static final String SCHEMA_FIELD = "schema";
    private static final String SPLIT_FIELD = "split";
    private static final String CONSTRAINTS_FIELD = "constraints";
    private static final String MAX_BLOCK_SIZE_FIELD = "maxBlockSize";
    private static final String MAX_INLINE_BLOCK_SIZE_FIELD = "maxInlineBlockSize";

    private ReadRecordsRequestSerDe() {
    }

    static final class Deserializer
    extends TypedDeserializer<FederationRequest> {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;
        private final TableNameSerDe.Deserializer tableNameDeserializer;
        private final ConstraintsSerDe.Deserializer constraintsDeserializer;
        private final SchemaSerDe.Deserializer schemaDeserializer;
        private final SplitSerDe.Deserializer splitDeserializer;

        Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer, TableNameSerDe.Deserializer tableNameDeserializer, ConstraintsSerDe.Deserializer constraintsDeserializer, SchemaSerDe.Deserializer schemaDeserializer, SplitSerDe.Deserializer splitDeserializer) {
            super(FederationRequest.class, ReadRecordsRequest.class);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
            this.tableNameDeserializer = Objects.requireNonNull(tableNameDeserializer, "tableNameDeserializer is null");
            this.constraintsDeserializer = Objects.requireNonNull(constraintsDeserializer, "constraintsDeserializer is null");
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
            this.splitDeserializer = Objects.requireNonNull(splitDeserializer, "splitDeserializer is null");
        }

        @Override
        protected FederationRequest doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, ReadRecordsRequestSerDe.IDENTITY_FIELD);
            FederatedIdentity identity = this.identityDeserializer.deserialize(jparser, ctxt);
            String queryId = this.getNextStringField(jparser, ReadRecordsRequestSerDe.QUERY_ID_FIELD);
            String catalogName = this.getNextStringField(jparser, ReadRecordsRequestSerDe.CATALOG_NAME_FIELD);
            this.assertFieldName(jparser, ReadRecordsRequestSerDe.TABLE_NAME_FIELD);
            TableName tableName = (TableName)this.tableNameDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, ReadRecordsRequestSerDe.SCHEMA_FIELD);
            Schema schema = this.schemaDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, ReadRecordsRequestSerDe.SPLIT_FIELD);
            Split split = (Split)this.splitDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, ReadRecordsRequestSerDe.CONSTRAINTS_FIELD);
            Constraints constraints = (Constraints)this.constraintsDeserializer.deserialize(jparser, ctxt);
            long maxBlockSize = Long.parseLong(this.getNextStringField(jparser, ReadRecordsRequestSerDe.MAX_BLOCK_SIZE_FIELD));
            long maxInlineBlockSize = Long.parseLong(this.getNextStringField(jparser, ReadRecordsRequestSerDe.MAX_INLINE_BLOCK_SIZE_FIELD));
            return new ReadRecordsRequest(identity, catalogName, queryId, tableName, schema, split, constraints, maxBlockSize, maxInlineBlockSize);
        }
    }

    static final class Serializer
    extends TypedSerializer<FederationRequest> {
        private final FederatedIdentitySerDe.Serializer identitySerializer;
        private final TableNameSerDe.Serializer tableNameSerializer;
        private final ConstraintsSerDe.Serializer constraintsSerializer;
        private final SchemaSerDe.Serializer schemaSerializer;
        private final SplitSerDe.Serializer splitSerializer;

        Serializer(FederatedIdentitySerDe.Serializer identitySerializer, TableNameSerDe.Serializer tableNameSerializer, ConstraintsSerDe.Serializer constraintsSerializer, SchemaSerDe.Serializer schemaSerializer, SplitSerDe.Serializer splitSerializer) {
            super(FederationRequest.class, ReadRecordsRequest.class);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
            this.tableNameSerializer = Objects.requireNonNull(tableNameSerializer, "tableNameSerializer is null");
            this.constraintsSerializer = Objects.requireNonNull(constraintsSerializer, "constraintsSerializer is null");
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
            this.splitSerializer = Objects.requireNonNull(splitSerializer, "splitSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            ReadRecordsRequest readRecordsRequest = (ReadRecordsRequest)federationRequest;
            jgen.writeFieldName(ReadRecordsRequestSerDe.IDENTITY_FIELD);
            this.identitySerializer.serialize(readRecordsRequest.getIdentity(), jgen, provider);
            jgen.writeStringField(ReadRecordsRequestSerDe.QUERY_ID_FIELD, readRecordsRequest.getQueryId());
            jgen.writeStringField(ReadRecordsRequestSerDe.CATALOG_NAME_FIELD, readRecordsRequest.getCatalogName());
            jgen.writeFieldName(ReadRecordsRequestSerDe.TABLE_NAME_FIELD);
            this.tableNameSerializer.serialize(readRecordsRequest.getTableName(), jgen, provider);
            jgen.writeFieldName(ReadRecordsRequestSerDe.SCHEMA_FIELD);
            this.schemaSerializer.serialize(readRecordsRequest.getSchema(), jgen, provider);
            jgen.writeFieldName(ReadRecordsRequestSerDe.SPLIT_FIELD);
            this.splitSerializer.serialize(readRecordsRequest.getSplit(), jgen, provider);
            jgen.writeFieldName(ReadRecordsRequestSerDe.CONSTRAINTS_FIELD);
            this.constraintsSerializer.serialize(readRecordsRequest.getConstraints(), jgen, provider);
            jgen.writeStringField(ReadRecordsRequestSerDe.MAX_BLOCK_SIZE_FIELD, String.valueOf(readRecordsRequest.getMaxBlockSize()));
            jgen.writeStringField(ReadRecordsRequestSerDe.MAX_INLINE_BLOCK_SIZE_FIELD, String.valueOf(readRecordsRequest.getMaxInlineBlockSize()));
        }
    }
}

