/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.spill.S3SpillLocation;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;

final class S3SpillLocationSerDe {
    private static final String BUCKET_FIELD = "bucket";
    private static final String KEY_FIELD = "key";
    private static final String DIRECTORY_FIELD = "directory";

    private S3SpillLocationSerDe() {
    }

    static final class Deserializer
    extends TypedDeserializer<SpillLocation> {
        Deserializer() {
            super(SpillLocation.class, S3SpillLocation.class);
        }

        @Override
        protected SpillLocation doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            String bucket = this.getNextStringField(jparser, S3SpillLocationSerDe.BUCKET_FIELD);
            String key = this.getNextStringField(jparser, S3SpillLocationSerDe.KEY_FIELD);
            boolean directory = this.getNextBoolField(jparser, S3SpillLocationSerDe.DIRECTORY_FIELD);
            return new S3SpillLocation(bucket, key, directory);
        }
    }

    static final class Serializer
    extends TypedSerializer<SpillLocation> {
        Serializer() {
            super(SpillLocation.class, S3SpillLocation.class);
        }

        @Override
        protected void doTypedSerialize(SpillLocation spillLocation, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            S3SpillLocation s3SpillLocation = (S3SpillLocation)spillLocation;
            jgen.writeStringField(S3SpillLocationSerDe.BUCKET_FIELD, s3SpillLocation.getBucket());
            jgen.writeStringField(S3SpillLocationSerDe.KEY_FIELD, s3SpillLocation.getKey());
            jgen.writeBooleanField(S3SpillLocationSerDe.DIRECTORY_FIELD, s3SpillLocation.isDirectory());
        }
    }
}

