/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.domain.predicate.ValueSet;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.ArrowTypeSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.RangeSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.ArrowType;

final class SortedRangeSetSerDe {
    private static final String TYPE_FIELD = "type";
    private static final String RANGES_FIELD = "ranges";
    private static final String NULL_ALLOWED_FIELD = "nullAllowed";

    private SortedRangeSetSerDe() {
    }

    static final class Deserializer
    extends TypedDeserializer<ValueSet> {
        private final ArrowTypeSerDe.Deserializer arrowTypeDeserializer;
        private final RangeSerDe.Deserializer rangeDeserializer;

        Deserializer(ArrowTypeSerDe.Deserializer arrowTypeDeserializer, RangeSerDe.Deserializer rangeDeserializer) {
            super(ValueSet.class, SortedRangeSet.class);
            this.arrowTypeDeserializer = Objects.requireNonNull(arrowTypeDeserializer, "arrowTypeDeserializer is null");
            this.rangeDeserializer = Objects.requireNonNull(rangeDeserializer, "rangeDeserializer is null");
        }

        @Override
        protected ValueSet doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, SortedRangeSetSerDe.TYPE_FIELD);
            ArrowType type = (ArrowType)this.arrowTypeDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, SortedRangeSetSerDe.RANGES_FIELD);
            this.validateArrayStart(jparser);
            ImmutableList.Builder rangesList = ImmutableList.builder();
            while (jparser.nextToken() != JsonToken.END_ARRAY) {
                this.validateObjectStart(jparser.getCurrentToken());
                rangesList.add((Object)this.rangeDeserializer.doDeserialize(jparser, ctxt));
                this.validateObjectEnd(jparser);
            }
            boolean nullAllowed = this.getNextBoolField(jparser, SortedRangeSetSerDe.NULL_ALLOWED_FIELD);
            return SortedRangeSet.copyOf(type, (List<Range>)rangesList.build(), nullAllowed);
        }
    }

    static final class Serializer
    extends TypedSerializer<ValueSet> {
        private final ArrowTypeSerDe.Serializer arrowTypeSerializer;
        private final RangeSerDe.Serializer rangeSerializer;

        Serializer(ArrowTypeSerDe.Serializer arrowTypeSerializer, RangeSerDe.Serializer rangeSerializer) {
            super(ValueSet.class, SortedRangeSet.class);
            this.arrowTypeSerializer = Objects.requireNonNull(arrowTypeSerializer, "arrowTypeSerializer is null");
            this.rangeSerializer = Objects.requireNonNull(rangeSerializer, "rangeSerializer is null");
        }

        @Override
        protected void doTypedSerialize(ValueSet valueSet, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            SortedRangeSet sortedRangeSet = (SortedRangeSet)valueSet;
            jgen.writeFieldName(SortedRangeSetSerDe.TYPE_FIELD);
            this.arrowTypeSerializer.serialize(sortedRangeSet.getType(), jgen, provider);
            jgen.writeFieldName(SortedRangeSetSerDe.RANGES_FIELD);
            jgen.writeStartArray();
            for (Range range : sortedRangeSet.getOrderedRanges()) {
                this.rangeSerializer.serialize(range, jgen, provider);
            }
            jgen.writeEndArray();
            jgen.writeBooleanField(SortedRangeSetSerDe.NULL_ALLOWED_FIELD, sortedRangeSet.isNullAllowed());
        }
    }
}

