/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocation;
import com.amazonaws.athena.connector.lambda.security.EncryptionKey;
import com.amazonaws.athena.connector.lambda.serde.BaseDeserializer;
import com.amazonaws.athena.connector.lambda.serde.BaseSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.EncryptionKeySerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SpillLocationSerDe;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

final class SplitSerDe {
    private static final String SPILL_LOCATION_FIELD = "spillLocation";
    private static final String ENCRYPTION_KEY_FIELD = "encryptionKey";
    private static final String PROPERTIES_FIELD = "properties";

    private SplitSerDe() {
    }

    static final class Deserializer
    extends BaseDeserializer<Split> {
        private final SpillLocationSerDe.Deserializer spillLocationDeserializer;
        private final EncryptionKeySerDe.Deserializer encryptionKeyDeserializer;

        Deserializer(SpillLocationSerDe.Deserializer spillLocationDeserializer, EncryptionKeySerDe.Deserializer encryptionKeyDeserializer) {
            super(Split.class);
            this.spillLocationDeserializer = Objects.requireNonNull(spillLocationDeserializer, "spillLocationDeserializer is null");
            this.encryptionKeyDeserializer = Objects.requireNonNull(encryptionKeyDeserializer, "encryptionKeyDeserializer is null");
        }

        @Override
        protected Split doDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, SplitSerDe.SPILL_LOCATION_FIELD);
            SpillLocation spillLocation = (SpillLocation)this.spillLocationDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, SplitSerDe.ENCRYPTION_KEY_FIELD);
            EncryptionKey encryptionKey = (EncryptionKey)this.encryptionKeyDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, SplitSerDe.PROPERTIES_FIELD);
            this.validateObjectStart(jparser.nextToken());
            ImmutableMap.Builder propertiesMap = ImmutableMap.builder();
            while (jparser.nextToken() != JsonToken.END_OBJECT) {
                String key = jparser.getValueAsString();
                jparser.nextToken();
                String value = jparser.getValueAsString();
                propertiesMap.put((Object)key, (Object)value);
            }
            return new Split(spillLocation, encryptionKey, (Map<String, String>)propertiesMap.build());
        }
    }

    static final class Serializer
    extends BaseSerializer<Split> {
        private final SpillLocationSerDe.Serializer spillLocationSerializer;
        private final EncryptionKeySerDe.Serializer encryptionKeySerializer;

        Serializer(SpillLocationSerDe.Serializer spillLocationSerializer, EncryptionKeySerDe.Serializer encryptionKeySerializer) {
            super(Split.class);
            this.spillLocationSerializer = Objects.requireNonNull(spillLocationSerializer, "spillLocationSerializer is null");
            this.encryptionKeySerializer = Objects.requireNonNull(encryptionKeySerializer, "encryptionKeySerializer is null");
        }

        @Override
        protected void doSerialize(Split split, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            jgen.writeFieldName(SplitSerDe.SPILL_LOCATION_FIELD);
            this.spillLocationSerializer.serialize(split.getSpillLocation(), jgen, provider);
            jgen.writeFieldName(SplitSerDe.ENCRYPTION_KEY_FIELD);
            if (split.getEncryptionKey() != null) {
                this.encryptionKeySerializer.serialize(split.getEncryptionKey(), jgen, provider);
            } else {
                jgen.writeNull();
            }
            jgen.writeObjectFieldStart(SplitSerDe.PROPERTIES_FIELD);
            for (Map.Entry<String, String> entry : split.getProperties().entrySet()) {
                jgen.writeFieldName(entry.getKey());
                jgen.writeString(entry.getValue());
            }
            jgen.writeEndObject();
        }
    }
}

