/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde.v2;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.security.FederatedIdentity;
import com.amazonaws.athena.connector.lambda.serde.FederatedIdentitySerDe;
import com.amazonaws.athena.connector.lambda.serde.TypedDeserializer;
import com.amazonaws.athena.connector.lambda.serde.TypedSerializer;
import com.amazonaws.athena.connector.lambda.serde.v2.BlockSerDe;
import com.amazonaws.athena.connector.lambda.serde.v2.SchemaSerDe;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionRequest;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionType;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.vector.types.pojo.Schema;

final class UserDefinedFunctionRequestSerDe {
    private static final String IDENTITY_FIELD = "identity";
    private static final String INPUT_RECORDS_FIELD = "inputRecords";
    private static final String OUTPUT_SCHEMA_FIELD = "outputSchema";
    private static final String METHOD_NAME_FIELD = "methodName";
    private static final String FUNCTION_TYPE_FIELD = "functionType";

    private UserDefinedFunctionRequestSerDe() {
    }

    static final class Deserializer
    extends TypedDeserializer<FederationRequest> {
        private final FederatedIdentitySerDe.Deserializer identityDeserializer;
        private final BlockSerDe.Deserializer blockDeserializer;
        private final SchemaSerDe.Deserializer schemaDeserializer;

        Deserializer(FederatedIdentitySerDe.Deserializer identityDeserializer, BlockSerDe.Deserializer blockDeserializer, SchemaSerDe.Deserializer schemaDeserializer) {
            super(FederationRequest.class, UserDefinedFunctionRequest.class);
            this.identityDeserializer = Objects.requireNonNull(identityDeserializer, "identityDeserializer is null");
            this.blockDeserializer = Objects.requireNonNull(blockDeserializer, "blockDeserializer is null");
            this.schemaDeserializer = Objects.requireNonNull(schemaDeserializer, "schemaDeserializer is null");
        }

        @Override
        protected FederationRequest doTypedDeserialize(JsonParser jparser, DeserializationContext ctxt) throws IOException {
            this.assertFieldName(jparser, UserDefinedFunctionRequestSerDe.IDENTITY_FIELD);
            FederatedIdentity identity = this.identityDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, UserDefinedFunctionRequestSerDe.INPUT_RECORDS_FIELD);
            Block inputRecords = (Block)this.blockDeserializer.deserialize(jparser, ctxt);
            this.assertFieldName(jparser, UserDefinedFunctionRequestSerDe.OUTPUT_SCHEMA_FIELD);
            Schema outputSchema = this.schemaDeserializer.deserialize(jparser, ctxt);
            String methodName = this.getNextStringField(jparser, UserDefinedFunctionRequestSerDe.METHOD_NAME_FIELD);
            UserDefinedFunctionType functionType = UserDefinedFunctionType.valueOf(this.getNextStringField(jparser, UserDefinedFunctionRequestSerDe.FUNCTION_TYPE_FIELD));
            return new UserDefinedFunctionRequest(identity, inputRecords, outputSchema, methodName, functionType);
        }
    }

    static final class Serializer
    extends TypedSerializer<FederationRequest> {
        private final FederatedIdentitySerDe.Serializer identitySerializer;
        private final BlockSerDe.Serializer blockSerializer;
        private final SchemaSerDe.Serializer schemaSerializer;

        Serializer(FederatedIdentitySerDe.Serializer identitySerializer, BlockSerDe.Serializer blockSerializer, SchemaSerDe.Serializer schemaSerializer) {
            super(FederationRequest.class, UserDefinedFunctionRequest.class);
            this.identitySerializer = Objects.requireNonNull(identitySerializer, "identitySerializer is null");
            this.blockSerializer = Objects.requireNonNull(blockSerializer, "blockSerializer is null");
            this.schemaSerializer = Objects.requireNonNull(schemaSerializer, "schemaSerializer is null");
        }

        @Override
        protected void doTypedSerialize(FederationRequest federationRequest, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            UserDefinedFunctionRequest userDefinedFunctionRequest = (UserDefinedFunctionRequest)federationRequest;
            jgen.writeFieldName(UserDefinedFunctionRequestSerDe.IDENTITY_FIELD);
            this.identitySerializer.serialize(federationRequest.getIdentity(), jgen, provider);
            jgen.writeFieldName(UserDefinedFunctionRequestSerDe.INPUT_RECORDS_FIELD);
            this.blockSerializer.serialize(userDefinedFunctionRequest.getInputRecords(), jgen, provider);
            jgen.writeFieldName(UserDefinedFunctionRequestSerDe.OUTPUT_SCHEMA_FIELD);
            this.schemaSerializer.serialize(userDefinedFunctionRequest.getOutputSchema(), jgen, provider);
            jgen.writeStringField(UserDefinedFunctionRequestSerDe.METHOD_NAME_FIELD, userDefinedFunctionRequest.getMethodName());
            jgen.writeStringField(UserDefinedFunctionRequestSerDe.FUNCTION_TYPE_FIELD, userDefinedFunctionRequest.getFunctionType().toString());
        }
    }
}

