/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class PublishScriptTest {
    private static final String publishScriptLocation = "../tools/publish.sh";

    @Test
    public void testBucketPolicy() throws IOException {
        String expected = "{\n  \"Version\": \"2012-10-17\",\n  \"Statement\": [\n    {\n      \"Effect\": \"Allow\",\n      \"Principal\": {\n        \"Service\":  \"serverlessrepo.amazonaws.com\"\n      },\n      \"Action\": \"s3:GetObject\",\n      \"Resource\": \"arn:$PARTITION:s3:::$1/*\",\n      \"Condition\": {\n        \"StringEquals\": {\n            \"aws:SourceAccount\": \"$account\"\n        }\n      }\n    }\n  ]\n}\n";
        StringBuilder actual = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(publishScriptLocation));){
            String line = br.readLine();
            boolean capture = false;
            while (line != null) {
                if (line.contains("EOM")) {
                    capture = !capture;
                } else if (capture) {
                    actual.append(line);
                    actual.append("\n");
                }
                line = br.readLine();
            }
        }
        Assert.assertEquals((Object)expected, (Object)actual.toString());
    }
}

