/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data;

import com.amazonaws.athena.connector.lambda.data.DateTimeFormatterUtil;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateTimeFormatterUtilTest {
    private static final Logger logger = LoggerFactory.getLogger(DateTimeFormatterUtilTest.class);
    private static final ZoneId DEFAULT_TIME_ZONE = ZoneId.of("UTC");
    @Rule
    public TestName testName = new TestName();

    @Before
    public void setUp() {
        logger.info("{}: enter", (Object)this.testName.getMethodName());
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    @After
    public void tearDown() {
        logger.info("{}: exit ", (Object)this.testName.getMethodName());
    }

    @Test
    public void stringToLocalDateTest() {
        LocalDate expected = LocalDate.of(2020, 2, 27);
        LocalDate actual = DateTimeFormatterUtil.stringToLocalDate((String)"27022020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE);
        Assert.assertEquals((Object)expected, (Object)actual);
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"2020-02-27", null, (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"27--02-2020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToLocalDateTestCustomerConfiguredFormatFail() {
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToLocalDate((String)"27--02-2020", (String)"ddMMyyyy", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToZonedDateTimeTest() {
        LocalDateTime localDateTimeExpected = LocalDateTime.of(2015, 12, 21, 17, 42, 34, 0);
        ZonedDateTime expected = ZonedDateTime.of(localDateTimeExpected, ZoneId.of("-05:00"));
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.stringToZonedDateTime((String)"2015-12-21T17:42:34-05:00", null, null));
        Assert.assertEquals((Object)localDateTimeExpected, (Object)DateTimeFormatterUtil.stringToZonedDateTime((String)"2015-12-21T17:42:34", (String)"yyyy-MM-dd'T'HH:mm:ss", (ZoneId)ZoneId.of("UTC")));
    }

    @Test
    public void stringTolDateTimeTest() {
        LocalDateTime expected = LocalDateTime.of(2020, 2, 27, 0, 2, 27);
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020-02-27", (String)"HH:mm:ss'S'yyyy-MM-dd", (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020-02-27", null, (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void stringToDateTimeTestCustomerConfiguredFormatFail() {
        Assert.assertNull((Object)DateTimeFormatterUtil.stringToDateTime((String)"00:02:27S2020---02-27", (String)"HH:mm:ss'S'yyyy-MM-dd", (ZoneId)DEFAULT_TIME_ZONE));
    }

    @Test
    public void bigDecimalToLocalDateTest() {
        LocalDate expected = LocalDate.of(2020, 2, 27);
        Instant instant = expected.atTime(LocalTime.MIDNIGHT).atZone(DEFAULT_TIME_ZONE).toInstant();
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.bigDecimalToLocalDate((BigDecimal)new BigDecimal(instant.toEpochMilli()), (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.bigDecimalToLocalDate(null, null));
    }

    @Test
    public void bigDecimalToLocalDateTimeTest() {
        LocalDateTime expected = LocalDateTime.of(2020, 2, 27, 0, 2, 27);
        Instant instant = expected.atZone(DEFAULT_TIME_ZONE).toInstant();
        Assert.assertEquals((Object)expected, (Object)DateTimeFormatterUtil.bigDecimalToLocalDateTime((BigDecimal)new BigDecimal(instant.toEpochMilli()), (ZoneId)DEFAULT_TIME_ZONE));
        Assert.assertNull((Object)DateTimeFormatterUtil.bigDecimalToLocalDateTime(null, null));
    }

    @Test
    public void inferDateTimeFormatTest() {
        String inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27");
        Assert.assertEquals((Object)"yyyy-MM-dd", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ss", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27Z");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020-02-27T00:02:27-05:00");
        Assert.assertEquals((Object)"yyyy-MM-dd'T'HH:mm:ssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"20200227T000227");
        Assert.assertEquals((Object)"yyyyMMdd'T'HHmmss", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"20200227T000227Z");
        Assert.assertEquals((Object)"yyyyMMdd'T'HHmmssZZ", (Object)inferredDateFormat);
        inferredDateFormat = DateTimeFormatterUtil.inferDateTimeFormat((String)"2020202020202020202020");
        Assert.assertNull((Object)inferredDateFormat);
    }

    @Test
    public void packDateTimeWithZoneTest() {
        LocalDateTime localDateTimeExpected = LocalDateTime.of(2015, 12, 21, 17, 42, 34, 0);
        ZoneId zoneIdExpected = ZoneId.of("-05:00");
        long expectedLong = 5942221840384541L;
        ZonedDateTime expectedZdt = ZonedDateTime.of(localDateTimeExpected, zoneIdExpected);
        Assert.assertEquals((long)expectedLong, (long)DateTimeFormatterUtil.packDateTimeWithZone((ZonedDateTime)expectedZdt));
        Assert.assertEquals((Object)expectedZdt, (Object)DateTimeFormatterUtil.constructZonedDateTime((long)expectedLong));
    }
}

