/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.data.helpers;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;

public class CustomFieldVector {
    public List<Object> objList = new ArrayList<Object>();
    public Field field;

    public CustomFieldVector(Field field) {
        this.field = field;
    }

    public void add(Object childObj) {
        if (childObj == null) {
            this.objList.add(null);
            return;
        }
        Types.MinorType fieldType = Types.getMinorTypeForArrowType((ArrowType)this.field.getType());
        switch (fieldType) {
            case LIST: {
                this.objList.add(((CustomFieldVector)childObj).objList);
                break;
            }
            case STRUCT: {
                String childName = ((CustomFieldVector)childObj).field.getName();
                List<Object> childObjList = ((CustomFieldVector)childObj).objList;
                for (int i = 0; i < childObjList.size(); ++i) {
                    if (i >= this.objList.size()) {
                        this.objList.add(new LinkedHashMap());
                    }
                    Map curr = (Map)this.objList.get(i);
                    if (childObjList.get(i) == null) continue;
                    curr.put(childName, childObjList.get(i));
                }
                break;
            }
            default: {
                this.objList.add(childObj);
            }
        }
    }

    public void addMap(CustomFieldVector keysObject, CustomFieldVector valuesObject) {
        if (keysObject.objList.size() != valuesObject.objList.size()) {
            throw new RuntimeException("Mismatched key/value object sizes.");
        }
        LinkedHashMap<Object, Object> keyValueMap = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < keysObject.objList.size(); ++i) {
            keyValueMap.put(keysObject.objList.get(i), valuesObject.objList.get(i));
        }
        this.objList.add(keyValueMap);
    }
}

