/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.domain.spill;

import com.amazonaws.athena.connector.lambda.domain.spill.SpillLocationVerifier;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.Bucket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpillLocationVerifierTest {
    private static final Logger logger = LoggerFactory.getLogger(SpillLocationVerifierTest.class);
    @Spy
    private SpillLocationVerifier spyVerifier;
    private List<String> bucketNames;

    @Before
    public void setup() {
        logger.info("setUpBefore - enter");
        this.bucketNames = Arrays.asList("bucket1", "bucket2", "bucket3");
        List<Bucket> buckets = this.createBuckets(this.bucketNames);
        AmazonS3 mockS3 = this.createMockS3(buckets);
        this.spyVerifier = (SpillLocationVerifier)Mockito.spy((Object)new SpillLocationVerifier(mockS3));
        logger.info("setUpBefore - exit");
    }

    @After
    public void tearDown() {
    }

    @Test
    public void checkBucketAuthZ() {
        logger.info("checkBucketAuthZ - enter");
        Random random = new Random();
        int index = random.nextInt(this.bucketNames.size());
        try {
            this.spyVerifier.checkBucketAuthZ(this.bucketNames.get(index));
        }
        catch (RuntimeException e) {
            Assert.fail((String)"checkBucketAuthZ failed");
        }
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).updateBucketState();
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).passOrFail();
        try {
            this.spyVerifier.checkBucketAuthZ(this.bucketNames.get(index));
        }
        catch (RuntimeException e) {
            Assert.fail((String)"checkBucketAuthZ failed");
        }
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).updateBucketState();
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)2))).passOrFail();
        try {
            this.spyVerifier.checkBucketAuthZ("");
        }
        catch (RuntimeException e) {
            Assert.fail((String)"checkBucketAuthZ failed");
        }
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).updateBucketState();
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)2))).passOrFail();
        logger.info("checkBucketAuthZ - exit");
    }

    @Test
    public void checkBucketAuthZFail() {
        logger.info("checkBucketAuthZFail - enter");
        String bucketNotOwn = "spill-bucket";
        try {
            this.spyVerifier.checkBucketAuthZ(bucketNotOwn);
            Assert.fail((String)"checkBucketAuthZFail failed");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)String.format("spill_bucket: \"%s\" not found under your account. Please make sure you have access to the bucket and spill_bucket input has no trailing '/'", bucketNotOwn), (Object)e.getMessage());
        }
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).updateBucketState();
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).passOrFail();
        try {
            this.spyVerifier.checkBucketAuthZ(bucketNotOwn);
            Assert.fail((String)"checkBucketAuthZFail failed");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((Object)String.format("spill_bucket: \"%s\" not found under your account. Please make sure you have access to the bucket and spill_bucket input has no trailing '/'", bucketNotOwn), (Object)e.getMessage());
        }
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)1))).updateBucketState();
        ((SpillLocationVerifier)Mockito.verify((Object)this.spyVerifier, (VerificationMode)Mockito.times((int)2))).passOrFail();
        logger.info("checkBucketAuthZFail - exit");
    }

    private AmazonS3 createMockS3(List<Bucket> buckets) {
        AmazonS3 s3mock = (AmazonS3)Mockito.mock(AmazonS3.class);
        Mockito.when((Object)s3mock.listBuckets()).thenReturn(buckets);
        return s3mock;
    }

    private List<Bucket> createBuckets(List<String> names) {
        ArrayList<Bucket> buckets = new ArrayList<Bucket>();
        for (String name : names) {
            Bucket bucket = (Bucket)Mockito.mock(Bucket.class);
            Mockito.when((Object)bucket.getName()).thenReturn((Object)name);
            buckets.add(bucket);
        }
        return buckets;
    }
}

