/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.examples;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.Split;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.examples.ExampleMetadataHandler;
import com.amazonaws.athena.connector.lambda.examples.SplitProperties;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequestType;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.IdentityUtil;
import com.amazonaws.athena.connector.lambda.security.LocalKeyFactory;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperUtil;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.lambda.invoke.LambdaFunctionException;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleMetadataHandlerTest {
    private static final Logger logger = LoggerFactory.getLogger(ExampleMetadataHandlerTest.class);
    private BlockAllocatorImpl allocator;
    private ExampleMetadataHandler metadataHandler;

    @Before
    public void setUp() {
        logger.info("setUpBefore - enter");
        this.allocator = new BlockAllocatorImpl();
        this.metadataHandler = new ExampleMetadataHandler((EncryptionKeyFactory)new LocalKeyFactory(), (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class), (AmazonAthena)Mockito.mock(AmazonAthena.class), "spill-bucket", "spill-prefix");
        logger.info("setUpBefore - exit");
    }

    @After
    public void after() {
        this.allocator.close();
    }

    @Test
    public void doListSchemas() {
        logger.info("doListSchemas - enter");
        ListSchemasRequest req = new ListSchemasRequest(IdentityUtil.fakeIdentity(), "queryId", "default");
        ObjectMapperUtil.assertSerialization(req);
        ListSchemasResponse res = this.metadataHandler.doListSchemaNames((BlockAllocator)this.allocator, req);
        ObjectMapperUtil.assertSerialization(res);
        logger.info("doListSchemas - {}", (Object)res.getSchemas());
        Assert.assertFalse((boolean)res.getSchemas().isEmpty());
        logger.info("doListSchemas - exit");
    }

    @Test
    public void doListTables() {
        logger.info("doListTables - enter");
        logger.info("doListTables - Test unlimited page size");
        ListTablesRequest req = new ListTablesRequest(IdentityUtil.fakeIdentity(), "queryId", "default", "schema", null, -1);
        ListTablesResponse expectedResponse = new ListTablesResponse("default", (Collection)new ImmutableList.Builder().add((Object)new TableName("schema", "table1")).add((Object)new TableName("schema", "table2")).add((Object)new TableName("schema", "table3")).add((Object)new TableName("schema", "table4")).add((Object)new TableName("schema", "table5")).build(), null);
        ObjectMapperUtil.assertSerialization(req);
        ListTablesResponse res = this.metadataHandler.doListTables((BlockAllocator)this.allocator, req);
        ObjectMapperUtil.assertSerialization(res);
        logger.info("doListTables - {}", (Object)res);
        Assert.assertEquals((String)"Expecting a different response", (Object)expectedResponse, (Object)res);
        logger.info("doListTables - Test first pagination request");
        req = new ListTablesRequest(IdentityUtil.fakeIdentity(), "queryId", "default", "schema", null, 3);
        expectedResponse = new ListTablesResponse("default", (Collection)new ImmutableList.Builder().add((Object)new TableName("schema", "table1")).add((Object)new TableName("schema", "table2")).add((Object)new TableName("schema", "table3")).build(), "table4");
        ObjectMapperUtil.assertSerialization(req);
        res = this.metadataHandler.doListTables((BlockAllocator)this.allocator, req);
        ObjectMapperUtil.assertSerialization(res);
        logger.info("doListTables - {}", (Object)res);
        Assert.assertEquals((String)"Expecting a different response", (Object)expectedResponse, (Object)res);
        logger.info("doListTables - Test second pagination request");
        req = new ListTablesRequest(IdentityUtil.fakeIdentity(), "queryId", "default", "schema", res.getNextToken(), 3);
        expectedResponse = new ListTablesResponse("default", (Collection)new ImmutableList.Builder().add((Object)new TableName("schema", "table4")).add((Object)new TableName("schema", "table5")).build(), null);
        ObjectMapperUtil.assertSerialization(req);
        res = this.metadataHandler.doListTables((BlockAllocator)this.allocator, req);
        ObjectMapperUtil.assertSerialization(res);
        logger.info("doListTables - {}", (Object)res);
        Assert.assertEquals((String)"Expecting a different response", (Object)expectedResponse, (Object)res);
        logger.info("doListTables - exit");
    }

    @Test
    public void doGetTable() {
        logger.info("doGetTable - enter");
        GetTableRequest req = new GetTableRequest(IdentityUtil.fakeIdentity(), "queryId", "default", new TableName("custom_source", "fake_table"));
        ObjectMapperUtil.assertSerialization(req);
        GetTableResponse res = this.metadataHandler.doGetTable((BlockAllocator)this.allocator, req);
        ObjectMapperUtil.assertSerialization(res);
        Assert.assertTrue((res.getSchema().getFields().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((res.getSchema().getCustomMetadata().size() > 0 ? 1 : 0) != 0);
        logger.info("doGetTable - {}", (Object)res);
        logger.info("doGetTable - exit");
    }

    @Test(expected=LambdaFunctionException.class)
    public void doGetTableFail() {
        try {
            logger.info("doGetTableFail - enter");
            GetTableRequest req = new GetTableRequest(IdentityUtil.fakeIdentity(), "queryId", "default", new TableName("lambda", "fake"));
            this.metadataHandler.doGetTable((BlockAllocator)this.allocator, req);
        }
        catch (Exception ex) {
            logger.info("doGetTableFail: ", (Throwable)ex);
            throw new LambdaFunctionException(ex.getMessage(), false, "repackaged");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doGetTableLayout() throws Exception {
        logger.info("doGetTableLayout - enter");
        Schema tableSchema = SchemaBuilder.newBuilder().addIntField("day").addIntField("month").addIntField("year").build();
        HashSet<String> partitionCols = new HashSet<String>();
        partitionCols.add("day");
        partitionCols.add("month");
        partitionCols.add("year");
        HashMap<String, SortedRangeSet> constraintsMap = new HashMap<String, SortedRangeSet>();
        constraintsMap.put("day", SortedRangeSet.copyOf((ArrowType)Types.MinorType.INT.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)20)), (boolean)false));
        constraintsMap.put("month", SortedRangeSet.copyOf((ArrowType)Types.MinorType.INT.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)2)), (boolean)false));
        constraintsMap.put("year", SortedRangeSet.copyOf((ArrowType)Types.MinorType.INT.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)1900)), (boolean)false));
        GetTableLayoutRequest req = null;
        GetTableLayoutResponse res = null;
        try {
            req = new GetTableLayoutRequest(IdentityUtil.fakeIdentity(), "queryId", "default", new TableName("schema1", "table1"), new Constraints(constraintsMap), tableSchema, partitionCols);
            ObjectMapperUtil.assertSerialization(req);
            res = this.metadataHandler.doGetTableLayout((BlockAllocator)this.allocator, req);
            ObjectMapperUtil.assertSerialization(res);
            logger.info("doGetTableLayout - {}", (Object)res);
            Block partitions = res.getPartitions();
            for (int row = 0; row < partitions.getRowCount() && row < 10; ++row) {
                logger.info("doGetTableLayout:{} {}", (Object)row, (Object)BlockUtils.rowToString((Block)partitions, (int)row));
            }
            Assert.assertTrue((partitions.getRowCount() > 0 ? 1 : 0) != 0);
            logger.info("doGetTableLayout: partitions[{}]", (Object)partitions.getRowCount());
        }
        finally {
            try {
                req.close();
                res.close();
            }
            catch (Exception ex) {
                logger.error("doGetTableLayout: ", (Throwable)ex);
            }
        }
        logger.info("doGetTableLayout - exit");
    }

    @Test
    public void doGetSplits() {
        logger.info("doGetSplits: enter");
        String yearCol = "year";
        String monthCol = "month";
        String dayCol = "day";
        Schema schema = SchemaBuilder.newBuilder().addField(yearCol, (ArrowType)new ArrowType.Int(16, false)).addField(monthCol, (ArrowType)new ArrowType.Int(16, false)).addField(dayCol, (ArrowType)new ArrowType.Int(16, false)).addField("location", (ArrowType)new ArrowType.Utf8()).addField("serde", (ArrowType)new ArrowType.Utf8()).build();
        ArrayList<String> partitionCols = new ArrayList<String>();
        partitionCols.add(yearCol);
        partitionCols.add(monthCol);
        partitionCols.add(dayCol);
        HashMap<String, SortedRangeSet> constraintsMap = new HashMap<String, SortedRangeSet>();
        constraintsMap.put(dayCol, SortedRangeSet.copyOf((ArrowType)Types.MinorType.INT.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)20)), (boolean)false));
        Block partitions = this.allocator.createBlock(schema);
        int num_partitions = 100;
        for (int i = 0; i < num_partitions; ++i) {
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(yearCol), (int)i, (Object)(2016 + i));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(monthCol), (int)i, (Object)(i % 12 + 1));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector(dayCol), (int)i, (Object)(i % 28 + 1));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector("location"), (int)i, (Object)String.valueOf(i));
            BlockUtils.setValue((FieldVector)partitions.getFieldVector("serde"), (int)i, (Object)"TextInputType");
        }
        partitions.setRowCount(num_partitions);
        String continuationToken = null;
        GetSplitsRequest originalReq = new GetSplitsRequest(IdentityUtil.fakeIdentity(), "queryId", "catalog_name", new TableName("schema", "table_name"), partitions, partitionCols, new Constraints(constraintsMap), continuationToken);
        int numContinuations = 0;
        do {
            GetSplitsRequest req = new GetSplitsRequest(originalReq, continuationToken);
            ObjectMapperUtil.assertSerialization(req);
            logger.info("doGetSplits: req[{}]", (Object)req);
            this.metadataHandler.setEncryption(numContinuations % 2 == 0);
            logger.info("doGetSplits: Toggle encryption " + (numContinuations % 2 == 0));
            GetSplitsResponse rawResponse = this.metadataHandler.doGetSplits((BlockAllocator)this.allocator, req);
            ObjectMapperUtil.assertSerialization(rawResponse);
            Assert.assertEquals((Object)MetadataRequestType.GET_SPLITS, (Object)rawResponse.getRequestType());
            GetSplitsResponse response = rawResponse;
            continuationToken = response.getContinuationToken();
            logger.info("doGetSplits: continuationToken[{}] - numSplits[{}] - maxSplits[{}]", new Object[]{continuationToken, response.getSplits().size(), 300});
            for (Split nextSplit : response.getSplits()) {
                if (numContinuations % 2 == 0) {
                    Assert.assertNotNull((Object)nextSplit.getEncryptionKey());
                } else {
                    Assert.assertNull((Object)nextSplit.getEncryptionKey());
                }
                Assert.assertNotNull((Object)nextSplit.getProperty(SplitProperties.LOCATION.getId()));
                Assert.assertNotNull((Object)nextSplit.getProperty(SplitProperties.SERDE.getId()));
                Assert.assertNotNull((Object)nextSplit.getProperty(SplitProperties.SPLIT_PART.getId()));
            }
            Assert.assertTrue((String)"Continuation criteria violated", (response.getSplits().size() == 300 && response.getContinuationToken() != null || response.getSplits().size() < 300 ? 1 : 0) != 0);
            if (continuationToken == null) continue;
            ++numContinuations;
        } while (continuationToken != null);
        Assert.assertTrue((numContinuations > 0 ? 1 : 0) != 0);
        logger.info("doGetSplits: exit");
    }
}

