/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.examples;

import com.amazonaws.athena.connector.lambda.data.Block;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockUtils;
import com.amazonaws.athena.connector.lambda.data.FieldResolver;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.data.projectors.ArrowValueProjector;
import com.amazonaws.athena.connector.lambda.data.projectors.ProjectorUtils;
import com.amazonaws.athena.connector.lambda.examples.ExampleUserDefinedFunctionHandler;
import com.amazonaws.athena.connector.lambda.request.FederationResponse;
import com.amazonaws.athena.connector.lambda.security.IdentityUtil;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperUtil;
import com.amazonaws.athena.connector.lambda.serde.VersionedObjectMapperFactory;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionRequest;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionResponse;
import com.amazonaws.athena.connector.lambda.udf.UserDefinedFunctionType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.complex.reader.FieldReader;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExampleUserDefinedFunctionHandlerTest {
    private static final Logger logger = LoggerFactory.getLogger(ExampleUserDefinedFunctionHandlerTest.class);
    private BlockAllocatorImpl allocator;
    private ExampleUserDefinedFunctionHandler exampleUserDefinedFunctionHandler;
    private ObjectMapper mapper;

    @Before
    public void setUp() {
        logger.info("setUpBefore - enter");
        this.exampleUserDefinedFunctionHandler = new ExampleUserDefinedFunctionHandler();
        this.allocator = new BlockAllocatorImpl();
        this.mapper = VersionedObjectMapperFactory.create((BlockAllocator)this.allocator);
    }

    @After
    public void after() {
        this.allocator.close();
    }

    @Test
    public void testMultiplyMethod() throws Exception {
        Schema inputSchema = SchemaBuilder.newBuilder().addField("factor1", Types.MinorType.INT.getType()).addField("factor2", Types.MinorType.INT.getType()).build();
        Schema outputSchema = SchemaBuilder.newBuilder().addField("product", Types.MinorType.INT.getType()).build();
        Block inputRecords = this.allocator.createBlock(inputSchema);
        inputRecords.setRowCount(1);
        IntVector inputVector1 = (IntVector)inputRecords.getFieldVector("factor1");
        IntVector inputVector2 = (IntVector)inputRecords.getFieldVector("factor2");
        inputVector1.setSafe(0, 2);
        inputVector2.setSafe(0, 3);
        UserDefinedFunctionResponse response = this.runAndAssertSerialization(inputRecords, outputSchema, "multiply");
        Block outputRecords = response.getRecords();
        Assert.assertEquals((long)1L, (long)outputRecords.getRowCount());
        FieldReader fieldReader = outputRecords.getFieldReader("product");
        ArrowValueProjector arrowValueProjector = ProjectorUtils.createArrowValueProjector((FieldReader)fieldReader);
        Assert.assertEquals((Object)this.exampleUserDefinedFunctionHandler.multiply(Integer.valueOf(2), Integer.valueOf(3)), (Object)arrowValueProjector.project(0));
    }

    @Test
    public void testConcatenateMethod() throws Exception {
        Schema inputSchema = SchemaBuilder.newBuilder().addListField("list", Types.MinorType.VARCHAR.getType()).build();
        Schema outputSchema = SchemaBuilder.newBuilder().addField("string", Types.MinorType.VARCHAR.getType()).build();
        Block inputRecords = this.allocator.createBlock(inputSchema);
        inputRecords.setRowCount(1);
        FieldVector fieldVector = inputRecords.getFieldVector("list");
        ArrayList value = Lists.newArrayList((Object[])new String[]{"a", "b"});
        BlockUtils.setComplexValue((FieldVector)fieldVector, (int)0, (FieldResolver)FieldResolver.DEFAULT, (Object)value);
        UserDefinedFunctionResponse response = this.runAndAssertSerialization(inputRecords, outputSchema, "concatenate");
        Block outputRecords = response.getRecords();
        Assert.assertEquals((long)1L, (long)outputRecords.getRowCount());
        FieldReader fieldReader = outputRecords.getFieldReader("string");
        ArrowValueProjector arrowValueProjector = ProjectorUtils.createArrowValueProjector((FieldReader)fieldReader);
        Assert.assertEquals((Object)this.exampleUserDefinedFunctionHandler.concatenate((List)Lists.newArrayList((Object[])new String[]{"a", "b"})), (Object)arrowValueProjector.project(0));
    }

    @Test
    public void testToJsonMethod() throws Exception {
        Schema inputSchema = SchemaBuilder.newBuilder().addStructField("struct").addChildField("struct", "int", Types.MinorType.INT.getType()).addChildField("struct", "double", Types.MinorType.FLOAT8.getType()).addChildField("struct", "string", Types.MinorType.VARCHAR.getType()).build();
        Schema outputSchema = SchemaBuilder.newBuilder().addField("json", Types.MinorType.VARCHAR.getType()).build();
        Block inputRecords = this.allocator.createBlock(inputSchema);
        inputRecords.setRowCount(1);
        FieldVector fieldVector = inputRecords.getFieldVector("struct");
        HashMap<String, Object> struct = new HashMap<String, Object>();
        struct.put("int", 10);
        struct.put("double", 2.3);
        struct.put("string", "test_string");
        BlockUtils.setComplexValue((FieldVector)fieldVector, (int)0, (FieldResolver)FieldResolver.DEFAULT, struct);
        UserDefinedFunctionResponse response = this.runAndAssertSerialization(inputRecords, outputSchema, "to_json");
        Block outputRecords = response.getRecords();
        Assert.assertEquals((long)1L, (long)outputRecords.getRowCount());
        FieldReader fieldReader = outputRecords.getFieldReader("json");
        ArrowValueProjector arrowValueProjector = ProjectorUtils.createArrowValueProjector((FieldReader)fieldReader);
        Assert.assertEquals((Object)this.exampleUserDefinedFunctionHandler.to_json(struct), (Object)arrowValueProjector.project(0));
    }

    @Test
    public void testGetDefaultValueIfNullMethod() throws Exception {
        Schema inputSchema = SchemaBuilder.newBuilder().addField("input", Types.MinorType.BIGINT.getType()).build();
        Schema outputSchema = SchemaBuilder.newBuilder().addField("output", Types.MinorType.BIGINT.getType()).build();
        Block inputRecords = this.allocator.createBlock(inputSchema);
        inputRecords.setRowCount(2);
        BigIntVector fieldVector = (BigIntVector)inputRecords.getFieldVector("input");
        fieldVector.setSafe(0, 123L);
        fieldVector.setNull(1);
        UserDefinedFunctionResponse response = this.runAndAssertSerialization(inputRecords, outputSchema, "get_default_value_if_null");
        Block outputRecords = response.getRecords();
        Assert.assertEquals((long)2L, (long)outputRecords.getRowCount());
        FieldReader fieldReader = outputRecords.getFieldReader("output");
        ArrowValueProjector arrowValueProjector = ProjectorUtils.createArrowValueProjector((FieldReader)fieldReader);
        Assert.assertEquals((Object)this.exampleUserDefinedFunctionHandler.get_default_value_if_null(Long.valueOf(123L)), (Object)arrowValueProjector.project(0));
        Assert.assertEquals((Object)this.exampleUserDefinedFunctionHandler.get_default_value_if_null(null), (Object)arrowValueProjector.project(1));
    }

    private UserDefinedFunctionResponse runAndAssertSerialization(Block inputRecords, Schema outputSchema, String methodName) throws IOException {
        UserDefinedFunctionRequest request = new UserDefinedFunctionRequest(IdentityUtil.fakeIdentity(), inputRecords, outputSchema, methodName, UserDefinedFunctionType.SCALAR);
        ObjectMapperUtil.assertSerialization(request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)out, (Object)request);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.exampleUserDefinedFunctionHandler.handleRequest((InputStream)byteArrayInputStream, (OutputStream)outputStream, null);
        UserDefinedFunctionResponse udfResponse = (UserDefinedFunctionResponse)this.mapper.readValue(outputStream.toByteArray(), FederationResponse.class);
        ObjectMapperUtil.assertSerialization(udfResponse);
        return udfResponse;
    }
}

