/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.handlers;

import com.amazonaws.athena.connector.lambda.QueryStatusChecker;
import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.BlockWriter;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.handlers.GlueMetadataHandler;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetSplitsResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutResponse;
import com.amazonaws.athena.connector.lambda.metadata.GetTableResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListSchemasResponse;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesRequest;
import com.amazonaws.athena.connector.lambda.metadata.ListTablesResponse;
import com.amazonaws.athena.connector.lambda.metadata.MetadataRequest;
import com.amazonaws.athena.connector.lambda.security.EncryptionKeyFactory;
import com.amazonaws.athena.connector.lambda.security.IdentityUtil;
import com.amazonaws.athena.connector.lambda.security.LocalKeyFactory;
import com.amazonaws.services.athena.AmazonAthena;
import com.amazonaws.services.glue.AWSGlue;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.GetDatabasesRequest;
import com.amazonaws.services.glue.model.GetDatabasesResult;
import com.amazonaws.services.glue.model.GetTableRequest;
import com.amazonaws.services.glue.model.GetTableResult;
import com.amazonaws.services.glue.model.GetTablesRequest;
import com.amazonaws.services.glue.model.GetTablesResult;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class GlueMetadataHandlerTest {
    private static final Logger logger = LoggerFactory.getLogger(GlueMetadataHandlerTest.class);
    private String accountId = IdentityUtil.fakeIdentity().getAccount();
    private String queryId = "queryId";
    private String catalog = "default";
    private String schema = "database1";
    private String table = "table1";
    private GlueMetadataHandler handler;
    private BlockAllocatorImpl allocator;
    private final List<Table> unPaginatedTables = new ImmutableList.Builder().add((Object)new Table().withName("table3")).add((Object)new Table().withName("table2")).add((Object)new Table().withName("table5")).add((Object)new Table().withName("table4")).add((Object)new Table().withName("table1")).build();
    private final ListTablesResponse fullListResponse = new ListTablesResponse(this.catalog, (Collection)new ImmutableList.Builder().add((Object)new TableName(this.schema, "table1")).add((Object)new TableName(this.schema, "table2")).add((Object)new TableName(this.schema, "table3")).add((Object)new TableName(this.schema, "table4")).add((Object)new TableName(this.schema, "table5")).build(), null);
    @Rule
    public TestName testName = new TestName();
    @Mock
    private AWSGlue mockGlue;
    @Mock
    private Context mockContext;

    @Before
    public void setUp() throws Exception {
        logger.info("{}: enter", (Object)this.testName.getMethodName());
        this.handler = new GlueMetadataHandler(this.mockGlue, (EncryptionKeyFactory)new LocalKeyFactory(), (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class), (AmazonAthena)Mockito.mock(AmazonAthena.class), "glue-test", "spill-bucket", "spill-prefix"){

            public GetTableLayoutResponse doGetTableLayout(BlockAllocator blockAllocator, GetTableLayoutRequest request) {
                throw new UnsupportedOperationException();
            }

            public void getPartitions(BlockWriter blockWriter, GetTableLayoutRequest request, QueryStatusChecker queryStatusChecker) throws Exception {
                throw new UnsupportedOperationException();
            }

            public GetSplitsResponse doGetSplits(BlockAllocator blockAllocator, GetSplitsRequest request) {
                throw new UnsupportedOperationException();
            }
        };
        this.allocator = new BlockAllocatorImpl();
        Mockito.when((Object)this.mockGlue.getTables((GetTablesRequest)Matchers.any(GetTablesRequest.class))).thenAnswer(invocationOnMock -> {
            GetTablesRequest request = (GetTablesRequest)invocationOnMock.getArguments()[0];
            String nextToken = request.getNextToken();
            int pageSize = request.getMaxResults() == null ? -1 : request.getMaxResults();
            Assert.assertEquals((Object)this.accountId, (Object)request.getCatalogId());
            Assert.assertEquals((Object)this.schema, (Object)request.getDatabaseName());
            GetTablesResult mockResult = (GetTablesResult)Mockito.mock(GetTablesResult.class);
            if (pageSize == -1) {
                Mockito.when((Object)mockResult.getTableList()).thenReturn(this.unPaginatedTables);
                Mockito.when((Object)mockResult.getNextToken()).thenReturn(null);
            } else {
                List paginatedTables = this.unPaginatedTables.stream().sorted(Comparator.comparing(Table::getName)).filter(table -> nextToken == null || table.getName().compareTo(nextToken) >= 0).limit(pageSize + 1).collect(Collectors.toList());
                if (paginatedTables.size() > pageSize) {
                    Mockito.when((Object)mockResult.getNextToken()).thenReturn((Object)((Table)paginatedTables.get(pageSize)).getName());
                    Mockito.when((Object)mockResult.getTableList()).thenReturn(paginatedTables.subList(0, pageSize));
                } else {
                    Mockito.when((Object)mockResult.getNextToken()).thenReturn(null);
                    Mockito.when((Object)mockResult.getTableList()).thenReturn(paginatedTables);
                }
            }
            return mockResult;
        });
    }

    @After
    public void tearDown() throws Exception {
        this.allocator.close();
        logger.info("{}: exit ", (Object)this.testName.getMethodName());
    }

    @Test
    public void doListSchemaNames() throws Exception {
        ArrayList<Database> databases = new ArrayList<Database>();
        databases.add(new Database().withName("db1"));
        databases.add(new Database().withName("db2"));
        Mockito.when((Object)this.mockGlue.getDatabases((GetDatabasesRequest)Matchers.any(GetDatabasesRequest.class))).thenAnswer(invocationOnMock -> {
            GetDatabasesRequest request = (GetDatabasesRequest)invocationOnMock.getArguments()[0];
            Assert.assertEquals((Object)this.accountId, (Object)request.getCatalogId());
            GetDatabasesResult mockResult = (GetDatabasesResult)Mockito.mock(GetDatabasesResult.class);
            if (request.getNextToken() == null) {
                Mockito.when((Object)mockResult.getDatabaseList()).thenReturn((Object)databases);
                Mockito.when((Object)mockResult.getNextToken()).thenReturn((Object)"next");
            } else {
                Mockito.when((Object)mockResult.getDatabaseList()).thenReturn(new ArrayList());
                Mockito.when((Object)mockResult.getNextToken()).thenReturn(null);
            }
            return mockResult;
        });
        ListSchemasRequest req = new ListSchemasRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog);
        ListSchemasResponse res = this.handler.doListSchemaNames((BlockAllocator)this.allocator, req);
        logger.info("doListSchemas - {}", (Object)res.getSchemas());
        Assert.assertEquals(databases.stream().map(next -> next.getName()).collect(Collectors.toList()), new ArrayList(res.getSchemas()));
        ((AWSGlue)Mockito.verify((Object)this.mockGlue, (VerificationMode)Mockito.times((int)2))).getDatabases((GetDatabasesRequest)Matchers.any(GetDatabasesRequest.class));
    }

    @Test
    public void doListTablesWithUnlimitedPageSize() throws Exception {
        ListTablesRequest req = new ListTablesRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, this.schema, null, -1);
        logger.info("Request - {}", (Object)req);
        ListTablesResponse actualResponse = this.handler.doListTables((BlockAllocator)this.allocator, req);
        logger.info("Response - {}", (Object)actualResponse);
        Assert.assertEquals((String)"Lists do not match.", (Object)this.fullListResponse, (Object)actualResponse);
    }

    @Test
    public void doListTablesWithLargePageSize() throws Exception {
        ListTablesRequest req = new ListTablesRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, this.schema, null, 150);
        logger.info("Request - {}", (Object)req);
        ListTablesResponse actualResponse = this.handler.doListTables((BlockAllocator)this.allocator, req);
        logger.info("Response - {}", (Object)actualResponse);
        Assert.assertEquals((String)"Lists do not match.", (Object)this.fullListResponse, (Object)actualResponse);
    }

    @Test
    public void doListTablesWithPagination() throws Exception {
        logger.info("First paginated request");
        ListTablesRequest req = new ListTablesRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, this.schema, null, 3);
        logger.info("Request - {}", (Object)req);
        ListTablesResponse expectedResponse = new ListTablesResponse(req.getCatalogName(), (Collection)new ImmutableList.Builder().add((Object)new TableName(req.getSchemaName(), "table1")).add((Object)new TableName(req.getSchemaName(), "table2")).add((Object)new TableName(req.getSchemaName(), "table3")).build(), "table4");
        ListTablesResponse actualResponse = this.handler.doListTables((BlockAllocator)this.allocator, req);
        logger.info("Response - {}", (Object)actualResponse);
        Assert.assertEquals((String)"Lists do not match.", (Object)expectedResponse, (Object)actualResponse);
        logger.info("Second paginated request");
        req = new ListTablesRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, this.schema, actualResponse.getNextToken(), 3);
        logger.info("Request - {}", (Object)req);
        expectedResponse = new ListTablesResponse(req.getCatalogName(), (Collection)new ImmutableList.Builder().add((Object)new TableName(req.getSchemaName(), "table4")).add((Object)new TableName(req.getSchemaName(), "table5")).build(), null);
        actualResponse = this.handler.doListTables((BlockAllocator)this.allocator, req);
        logger.info("Response - {}", (Object)actualResponse);
        Assert.assertEquals((String)"Lists do not match.", (Object)expectedResponse, (Object)actualResponse);
    }

    @Test
    public void doGetTable() throws Exception {
        String sourceTable = "My-Table";
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        expectedParams.put("sourceTable", sourceTable);
        expectedParams.put("columnMapping", "col2=Col2,col3=Col3, col4=Col4");
        expectedParams.put("datetimeFormatMapping", "col2=someformat2, col1=someformat1 ");
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column().withName("col1").withType("int").withComment("comment"));
        columns.add(new Column().withName("col2").withType("bigint").withComment("comment"));
        columns.add(new Column().withName("col3").withType("string").withComment("comment"));
        columns.add(new Column().withName("col4").withType("timestamp").withComment("comment"));
        columns.add(new Column().withName("col5").withType("date").withComment("comment"));
        columns.add(new Column().withName("col6").withType("timestamptz").withComment("comment"));
        columns.add(new Column().withName("col7").withType("timestamptz").withComment("comment"));
        ArrayList partitionKeys = new ArrayList();
        columns.add(new Column().withName("partition_col1").withType("int").withComment("comment"));
        Table mockTable = (Table)Mockito.mock(Table.class);
        StorageDescriptor mockSd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)mockTable.getName()).thenReturn((Object)this.table);
        Mockito.when((Object)mockTable.getStorageDescriptor()).thenReturn((Object)mockSd);
        Mockito.when((Object)mockTable.getParameters()).thenReturn(expectedParams);
        Mockito.when((Object)mockSd.getColumns()).thenReturn(columns);
        Mockito.when((Object)this.mockGlue.getTable((GetTableRequest)Matchers.any(GetTableRequest.class))).thenAnswer(invocationOnMock -> {
            GetTableRequest request = (GetTableRequest)invocationOnMock.getArguments()[0];
            Assert.assertEquals((Object)this.accountId, (Object)request.getCatalogId());
            Assert.assertEquals((Object)this.schema, (Object)request.getDatabaseName());
            Assert.assertEquals((Object)this.table, (Object)request.getName());
            GetTableResult mockResult = (GetTableResult)Mockito.mock(GetTableResult.class);
            Mockito.when((Object)mockResult.getTable()).thenReturn((Object)mockTable);
            return mockResult;
        });
        com.amazonaws.athena.connector.lambda.metadata.GetTableRequest req = new com.amazonaws.athena.connector.lambda.metadata.GetTableRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, new TableName(this.schema, this.table));
        GetTableResponse res = this.handler.doGetTable((BlockAllocator)this.allocator, req);
        logger.info("doGetTable - {}", (Object)res);
        Assert.assertTrue((res.getSchema().getFields().size() == 8 ? 1 : 0) != 0);
        Assert.assertTrue((res.getSchema().getCustomMetadata().size() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)res.getSchema().getCustomMetadata().containsKey("datetimeFormatMapping"));
        Assert.assertEquals(res.getSchema().getCustomMetadata().get("datetimeFormatMappingNormalized"), (Object)"Col2=someformat2,col1=someformat1");
        Assert.assertEquals((Object)sourceTable, (Object)GlueMetadataHandler.getSourceTableName((Schema)res.getSchema()));
        Assert.assertNotNull((Object)res.getSchema().findField("partition_col1"));
        Assert.assertNotNull((Object)res.getSchema().findField("col1"));
        Assert.assertNotNull((Object)res.getSchema().findField("Col2"));
        Assert.assertNotNull((Object)res.getSchema().findField("Col3"));
        Assert.assertNotNull((Object)res.getSchema().findField("Col4"));
        Assert.assertNotNull((Object)res.getSchema().findField("col5"));
        Assert.assertNotNull((Object)res.getSchema().findField("col6"));
        Assert.assertNotNull((Object)res.getSchema().findField("col7"));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("partition_col1").getType()).equals((Object)Types.MinorType.INT));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("col1").getType()).equals((Object)Types.MinorType.INT));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("Col2").getType()).equals((Object)Types.MinorType.BIGINT));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("Col3").getType()).equals((Object)Types.MinorType.VARCHAR));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("Col4").getType()).equals((Object)Types.MinorType.DATEMILLI));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("col5").getType()).equals((Object)Types.MinorType.DATEDAY));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("col6").getType()).equals((Object)Types.MinorType.TIMESTAMPMILLITZ));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("col7").getType()).equals((Object)Types.MinorType.TIMESTAMPMILLITZ));
    }

    @Test
    public void populateSourceTableFromLocation() {
        HashMap params = new HashMap();
        List<String> partitions = Arrays.asList("aws", "aws-cn", "aws-us-gov");
        for (String partition : partitions) {
            StorageDescriptor storageDescriptor = new StorageDescriptor().withLocation(String.format("arn:%s:dynamodb:us-east-1:012345678910:table/My-Table", partition));
            Table table = new Table().withParameters(params).withStorageDescriptor(storageDescriptor);
            SchemaBuilder schemaBuilder = new SchemaBuilder();
            GlueMetadataHandler.populateSourceTableNameIfAvailable((Table)table, (SchemaBuilder)schemaBuilder);
            Schema schema = schemaBuilder.build();
            Assert.assertEquals((Object)"My-Table", (Object)GlueMetadataHandler.getSourceTableName((Schema)schema));
        }
    }

    @Test
    public void doGetTableEmptyComment() throws Exception {
        String sourceTable = "My-Table";
        HashMap<String, String> expectedParams = new HashMap<String, String>();
        expectedParams.put("sourceTable", sourceTable);
        expectedParams.put("col1", "col1");
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.add(new Column().withName("col1").withType("int").withComment(" "));
        Table mockTable = (Table)Mockito.mock(Table.class);
        StorageDescriptor mockSd = (StorageDescriptor)Mockito.mock(StorageDescriptor.class);
        Mockito.when((Object)mockTable.getName()).thenReturn((Object)this.table);
        Mockito.when((Object)mockTable.getStorageDescriptor()).thenReturn((Object)mockSd);
        Mockito.when((Object)mockTable.getParameters()).thenReturn(expectedParams);
        Mockito.when((Object)mockSd.getColumns()).thenReturn(columns);
        Mockito.when((Object)this.mockGlue.getTable((GetTableRequest)Matchers.any(GetTableRequest.class))).thenAnswer(invocationOnMock -> {
            GetTableRequest request = (GetTableRequest)invocationOnMock.getArguments()[0];
            Assert.assertEquals((Object)this.accountId, (Object)request.getCatalogId());
            Assert.assertEquals((Object)this.schema, (Object)request.getDatabaseName());
            Assert.assertEquals((Object)this.table, (Object)request.getName());
            GetTableResult mockResult = (GetTableResult)Mockito.mock(GetTableResult.class);
            Mockito.when((Object)mockResult.getTable()).thenReturn((Object)mockTable);
            return mockResult;
        });
        com.amazonaws.athena.connector.lambda.metadata.GetTableRequest req = new com.amazonaws.athena.connector.lambda.metadata.GetTableRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, new TableName(this.schema, this.table));
        GetTableResponse res = this.handler.doGetTable((BlockAllocator)this.allocator, req);
        logger.info("doGetTable - {}", (Object)res);
        Assert.assertNotNull((Object)res.getSchema().findField("col1"));
        Assert.assertTrue((boolean)Types.getMinorTypeForArrowType((ArrowType)res.getSchema().findField("col1").getType()).equals((Object)Types.MinorType.INT));
    }

    @Test
    public void testGetCatalog() {
        com.amazonaws.athena.connector.lambda.metadata.GetTableRequest req = new com.amazonaws.athena.connector.lambda.metadata.GetTableRequest(IdentityUtil.fakeIdentity(), this.queryId, this.catalog, new TableName(this.schema, this.table));
        String catalog = this.handler.getCatalog((MetadataRequest)req);
        Assert.assertEquals((Object)IdentityUtil.fakeIdentity().getAccount(), (Object)catalog);
        Mockito.when((Object)this.mockContext.getInvokedFunctionArn()).thenReturn((Object)"arn:aws:lambda:us-east-1:012345678912:function:athena-123");
        req.setContext(this.mockContext);
        catalog = this.handler.getCatalog((MetadataRequest)req);
        Assert.assertEquals((Object)"012345678912", (Object)catalog);
        Mockito.when((Object)this.mockContext.getInvokedFunctionArn()).thenReturn((Object)"arn:aws:lambda:us-east-1:012345678912:function:");
        req.setContext(this.mockContext);
        catalog = this.handler.getCatalog((MetadataRequest)req);
        Assert.assertEquals((Object)IdentityUtil.fakeIdentity().getAccount(), (Object)catalog);
        Mockito.when((Object)this.mockContext.getInvokedFunctionArn()).thenReturn(null);
        req.setContext(this.mockContext);
        catalog = this.handler.getCatalog((MetadataRequest)req);
        Assert.assertEquals((Object)IdentityUtil.fakeIdentity().getAccount(), (Object)catalog);
    }
}

