/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.metadata.glue;

import com.amazonaws.athena.connector.lambda.metadata.glue.GlueTypeParser;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlueTypeParserTest {
    private static final Logger logger = LoggerFactory.getLogger(GlueTypeParserTest.class);

    @Test
    public void parseTest() {
        logger.info("parseTest: enter");
        String input = "STRUCT <  street_address: STRUCT <    street_number: INT,    street_name: STRING,    street_type: STRING  >,  country: STRING,  postal_code: ARRAY<STRING>>";
        ArrayList<GlueTypeParser.Token> expectedTokens = new ArrayList<GlueTypeParser.Token>();
        expectedTokens.add(new GlueTypeParser.Token("STRUCT", GlueTypeParser.FIELD_START, 8));
        expectedTokens.add(new GlueTypeParser.Token("street_address", GlueTypeParser.FIELD_DIV, 25));
        expectedTokens.add(new GlueTypeParser.Token("STRUCT", GlueTypeParser.FIELD_START, 34));
        expectedTokens.add(new GlueTypeParser.Token("street_number", GlueTypeParser.FIELD_DIV, 52));
        expectedTokens.add(new GlueTypeParser.Token("INT", GlueTypeParser.FIELD_SEP, 57));
        expectedTokens.add(new GlueTypeParser.Token("street_name", GlueTypeParser.FIELD_DIV, 73));
        expectedTokens.add(new GlueTypeParser.Token("STRING", GlueTypeParser.FIELD_SEP, 81));
        expectedTokens.add(new GlueTypeParser.Token("street_type", GlueTypeParser.FIELD_DIV, 97));
        expectedTokens.add(new GlueTypeParser.Token("STRING", GlueTypeParser.FIELD_END, 107));
        expectedTokens.add(new GlueTypeParser.Token("", GlueTypeParser.FIELD_SEP, 108));
        expectedTokens.add(new GlueTypeParser.Token("country", GlueTypeParser.FIELD_DIV, 118));
        expectedTokens.add(new GlueTypeParser.Token("STRING", GlueTypeParser.FIELD_SEP, 126));
        expectedTokens.add(new GlueTypeParser.Token("postal_code", GlueTypeParser.FIELD_DIV, 140));
        expectedTokens.add(new GlueTypeParser.Token("ARRAY", GlueTypeParser.FIELD_START, 147));
        expectedTokens.add(new GlueTypeParser.Token("STRING", GlueTypeParser.FIELD_END, 154));
        expectedTokens.add(new GlueTypeParser.Token("", GlueTypeParser.FIELD_END, 155));
        GlueTypeParser parser = new GlueTypeParser(input);
        int pos = 0;
        while (parser.hasNext()) {
            GlueTypeParser.Token next = parser.next();
            logger.info("parseTest: {} => {}", (Object)next.getValue(), (Object)next.getMarker());
            Assert.assertEquals(expectedTokens.get(pos++), (Object)next);
        }
        logger.info("parseTest: exits");
    }

    @Test
    public void parseTestSimple() {
        logger.info("parseTestSimple: enter");
        String input = "string";
        ArrayList<GlueTypeParser.Token> expectedTokens = new ArrayList<GlueTypeParser.Token>();
        expectedTokens.add(new GlueTypeParser.Token("string", null, 6));
        GlueTypeParser parser = new GlueTypeParser(input);
        int pos = 0;
        while (parser.hasNext()) {
            GlueTypeParser.Token next = parser.next();
            logger.info("parseTest: {} => {}", (Object)next.getValue(), (Object)next.getMarker());
            Assert.assertEquals(expectedTokens.get(pos++), (Object)next);
        }
        logger.info("parseTestSimple: exits");
    }

    @Test
    public void parseTestComplex() {
        logger.info("parseTestComplex: enter");
        String input = "ARRAY<STRUCT<time:timestamp, measure_value\\:\\:double:double>>";
        ArrayList<GlueTypeParser.Token> expectedTokens = new ArrayList<GlueTypeParser.Token>();
        expectedTokens.add(new GlueTypeParser.Token("ARRAY", GlueTypeParser.FIELD_START, 6));
        expectedTokens.add(new GlueTypeParser.Token("STRUCT", GlueTypeParser.FIELD_START, 13));
        expectedTokens.add(new GlueTypeParser.Token("time", GlueTypeParser.FIELD_DIV, 18));
        expectedTokens.add(new GlueTypeParser.Token("timestamp", GlueTypeParser.FIELD_SEP, 28));
        expectedTokens.add(new GlueTypeParser.Token("measure_value::double", GlueTypeParser.FIELD_DIV, 53));
        expectedTokens.add(new GlueTypeParser.Token("double", GlueTypeParser.FIELD_END, 60));
        expectedTokens.add(new GlueTypeParser.Token("", GlueTypeParser.FIELD_END, 61));
        GlueTypeParser parser = new GlueTypeParser(input);
        int pos = 0;
        while (parser.hasNext()) {
            GlueTypeParser.Token next = parser.next();
            logger.info("parseTest: {} => {} @ {}", new Object[]{next.getValue(), next.getMarker(), next.getPos()});
            Assert.assertEquals(expectedTokens.get(pos++), (Object)next);
        }
        logger.info("parseTestSimple: exits");
    }
}

