/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.security;

import com.amazonaws.athena.connector.lambda.security.CachableSecretsManager;
import com.amazonaws.services.secretsmanager.AWSSecretsManager;
import com.amazonaws.services.secretsmanager.model.GetSecretValueRequest;
import com.amazonaws.services.secretsmanager.model.GetSecretValueResult;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class CacheableSecretsManagerTest {
    private AWSSecretsManager mockSecretsManager;
    private CachableSecretsManager cachableSecretsManager;

    @Before
    public void setup() {
        this.mockSecretsManager = (AWSSecretsManager)Mockito.mock(AWSSecretsManager.class);
        this.cachableSecretsManager = new CachableSecretsManager(this.mockSecretsManager);
    }

    @After
    public void after() {
        Mockito.reset((Object[])new AWSSecretsManager[]{this.mockSecretsManager});
    }

    @Test
    public void expirationTest() {
        this.cachableSecretsManager.addCacheEntry("test", "value", System.currentTimeMillis());
        Assert.assertEquals((Object)"value", (Object)this.cachableSecretsManager.getSecret("test"));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mockSecretsManager});
        Mockito.reset((Object[])new AWSSecretsManager[]{this.mockSecretsManager});
        Mockito.when((Object)this.mockSecretsManager.getSecretValue((GetSecretValueRequest)Matchers.any(GetSecretValueRequest.class))).thenAnswer(invocation -> {
            GetSecretValueRequest request = (GetSecretValueRequest)invocation.getArgumentAt(0, GetSecretValueRequest.class);
            if (request.getSecretId().equalsIgnoreCase("test")) {
                return new GetSecretValueResult().withSecretString("value2");
            }
            throw new RuntimeException();
        });
        this.cachableSecretsManager.addCacheEntry("test", "value", 0L);
        Assert.assertEquals((Object)"value2", (Object)this.cachableSecretsManager.getSecret("test"));
    }

    @Test
    public void evictionTest() {
        for (int i = 0; i < 10; ++i) {
            this.cachableSecretsManager.addCacheEntry("test" + i, "value" + i, System.currentTimeMillis());
        }
        Mockito.when((Object)this.mockSecretsManager.getSecretValue((GetSecretValueRequest)Matchers.any(GetSecretValueRequest.class))).thenAnswer(invocation -> {
            GetSecretValueRequest request = (GetSecretValueRequest)invocation.getArgumentAt(0, GetSecretValueRequest.class);
            return new GetSecretValueResult().withSecretString(request.getSecretId() + "_value");
        });
        Assert.assertEquals((Object)"test_value", (Object)this.cachableSecretsManager.getSecret("test"));
        Assert.assertEquals((Object)"test0_value", (Object)this.cachableSecretsManager.getSecret("test0"));
        ((AWSSecretsManager)Mockito.verify((Object)this.mockSecretsManager, (VerificationMode)Mockito.times((int)2))).getSecretValue((GetSecretValueRequest)Matchers.any(GetSecretValueRequest.class));
    }

    @Test
    public void resolveSecrets() {
        Mockito.when((Object)this.mockSecretsManager.getSecretValue((GetSecretValueRequest)Matchers.any(GetSecretValueRequest.class))).thenAnswer(invocation -> {
            GetSecretValueRequest request = (GetSecretValueRequest)invocation.getArgumentAt(0, GetSecretValueRequest.class);
            String result = request.getSecretId();
            if (result.equalsIgnoreCase("unknown")) {
                throw new RuntimeException("Unknown secret!");
            }
            return new GetSecretValueResult().withSecretString(result);
        });
        String oneSecret = "${OneSecret}";
        String oneExpected = "OneSecret";
        Assert.assertEquals((Object)oneExpected, (Object)this.cachableSecretsManager.resolveSecrets(oneSecret));
        String twoSecrets = "ThisIsMyStringWith${TwoSecret}SuperSecret${Secrets}";
        String twoExpected = "ThisIsMyStringWithTwoSecretSuperSecretSecrets";
        Assert.assertEquals((Object)twoExpected, (Object)this.cachableSecretsManager.resolveSecrets(twoSecrets));
        String noSecrets = "ThisIsMyStringWithTwoSecretSuperSecretSecrets";
        String noSecretsExpected = "ThisIsMyStringWithTwoSecretSuperSecretSecrets";
        Assert.assertEquals((Object)noSecretsExpected, (Object)this.cachableSecretsManager.resolveSecrets(noSecrets));
        String commonErrors = "ThisIsM}yStringWi${thTwoSecretS{uperSecretSecrets";
        String commonErrorsExpected = "ThisIsM}yStringWi${thTwoSecretS{uperSecretSecrets";
        Assert.assertEquals((Object)commonErrorsExpected, (Object)this.cachableSecretsManager.resolveSecrets(commonErrors));
        String unknownSecret = "This${Unknown}";
        try {
            this.cachableSecretsManager.resolveSecrets(unknownSecret);
            Assert.fail((String)"Should not see this!");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

