/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.data.SchemaBuilder;
import com.amazonaws.athena.connector.lambda.domain.TableName;
import com.amazonaws.athena.connector.lambda.domain.predicate.Constraints;
import com.amazonaws.athena.connector.lambda.domain.predicate.Range;
import com.amazonaws.athena.connector.lambda.domain.predicate.SortedRangeSet;
import com.amazonaws.athena.connector.lambda.metadata.GetTableLayoutRequest;
import com.amazonaws.athena.connector.lambda.security.IdentityUtil;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperUtil;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstraintSerializationTest {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintSerializationTest.class);
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void serializationTest() throws Exception {
        logger.info("serializationTest - enter");
        HashMap<String, SortedRangeSet> constraintsMap = new HashMap<String, SortedRangeSet>();
        constraintsMap.put("col2", SortedRangeSet.copyOf((ArrowType)Types.MinorType.BIGINT.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIGINT.getType(), (Object)950L)), (boolean)false));
        constraintsMap.put("col3", SortedRangeSet.copyOf((ArrowType)Types.MinorType.BIT.getType(), (List)ImmutableList.of((Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.BIT.getType(), (Object)false)), (boolean)false));
        constraintsMap.put("col4", SortedRangeSet.copyOf((ArrowType)Types.MinorType.FLOAT8.getType(), (List)ImmutableList.of((Object)Range.greaterThan((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.FLOAT8.getType(), (Object)950.0)), (boolean)false));
        constraintsMap.put("col5", SortedRangeSet.copyOf((ArrowType)Types.MinorType.VARCHAR.getType(), (List)ImmutableList.of((Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.VARCHAR.getType(), (Object)"8"), (Object)Range.equal((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.VARCHAR.getType(), (Object)"9")), (boolean)false));
        try (GetTableLayoutRequest req = new GetTableLayoutRequest(IdentityUtil.fakeIdentity(), "queryId", "default", new TableName("schema1", "table1"), new Constraints(constraintsMap), SchemaBuilder.newBuilder().build(), new HashSet());){
            ObjectMapperUtil.assertSerialization(req);
        }
        logger.info("serializationTest - exit");
    }
}

