/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.data.BlockAllocator;
import com.amazonaws.athena.connector.lambda.data.BlockAllocatorImpl;
import com.amazonaws.athena.connector.lambda.domain.predicate.Marker;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkerSerializationTest {
    private static final Logger logger = LoggerFactory.getLogger(MarkerSerializationTest.class);
    private BlockAllocatorImpl allocator;

    @Before
    public void setup() {
        this.allocator = new BlockAllocatorImpl();
    }

    @After
    public void tearDown() {
        this.allocator.close();
    }

    @Test
    public void serializationTest() throws IOException {
        logger.info("serializationTest - enter");
        ObjectMapper serializer = ObjectMapperFactory.create((BlockAllocator)new BlockAllocatorImpl());
        int expectedValue = 1024;
        Marker expectedMarker = Marker.exactly((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType(), (Object)expectedValue);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        serializer.writeValue((OutputStream)out, (Object)expectedMarker);
        ObjectMapper deserializer = ObjectMapperFactory.create((BlockAllocator)this.allocator);
        Marker actualMarker = (Marker)deserializer.readValue((InputStream)new ByteArrayInputStream(out.toByteArray()), Marker.class);
        Assert.assertEquals((Object)expectedMarker.getSchema().getCustomMetadata(), (Object)actualMarker.getSchema().getCustomMetadata());
        Assert.assertEquals((Object)expectedMarker.getSchema().getFields(), (Object)actualMarker.getSchema().getFields());
        Assert.assertEquals((Object)expectedMarker.getBound(), (Object)actualMarker.getBound());
        Assert.assertEquals((Object)expectedMarker.getValue(), (Object)actualMarker.getValue());
        Assert.assertEquals((Object)expectedValue, (Object)actualMarker.getValue());
        Assert.assertEquals((Object)false, (Object)actualMarker.isNullValue());
        logger.info("serializationTest - exit");
    }

    @Test
    public void nullableSerializationTest() throws IOException {
        logger.info("nullableSerializationTest - enter");
        ObjectMapper serializer = ObjectMapperFactory.create((BlockAllocator)new BlockAllocatorImpl());
        Marker expectedMarker = Marker.nullMarker((BlockAllocator)this.allocator, (ArrowType)Types.MinorType.INT.getType());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        serializer.writeValue((OutputStream)out, (Object)expectedMarker);
        ObjectMapper deserializer = ObjectMapperFactory.create((BlockAllocator)this.allocator);
        Marker actualMarker = (Marker)deserializer.readValue((InputStream)new ByteArrayInputStream(out.toByteArray()), Marker.class);
        Assert.assertEquals((Object)expectedMarker.getSchema().getCustomMetadata(), (Object)actualMarker.getSchema().getCustomMetadata());
        Assert.assertEquals((Object)expectedMarker.getSchema().getFields(), (Object)actualMarker.getSchema().getFields());
        Assert.assertEquals((Object)expectedMarker.getBound(), (Object)actualMarker.getBound());
        Assert.assertEquals((Object)true, (Object)actualMarker.isNullValue());
        logger.info("nullableSerializationTest - exit");
    }
}

