/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.athena.connector.lambda.serde;

import com.amazonaws.athena.connector.lambda.request.FederationRequest;
import com.amazonaws.athena.connector.lambda.request.PingRequest;
import com.amazonaws.athena.connector.lambda.serde.ObjectMapperUtil;
import com.amazonaws.athena.connector.lambda.serde.TypedSerDeTest;
import com.fasterxml.jackson.core.JsonEncoding;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingRequestSerDeTest
extends TypedSerDeTest<FederationRequest> {
    private static final Logger logger = LoggerFactory.getLogger(PingRequestSerDeTest.class);

    @Before
    public void beforeTest() throws IOException {
        this.expected = new PingRequest(this.federatedIdentity, "test-catalog", "test-query-id");
        String expectedSerDeFile = this.utils.getResourceOrFail("serde", "PingRequest.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
    }

    @Override
    @Test
    public void serialize() throws IOException {
        logger.info("serialize: enter");
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.mapper.writeValue((OutputStream)outputStream, this.expected);
        String actual = new String(outputStream.toByteArray(), JsonEncoding.UTF8.getJavaName());
        logger.info("serialize: serialized text[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expectedSerDeText, (Object)actual);
        logger.info("serialize: exit");
    }

    @Override
    @Test
    public void deserialize() throws IOException {
        logger.info("deserialize: enter");
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        PingRequest actual = (PingRequest)this.mapper.readValue((InputStream)input, FederationRequest.class);
        logger.info("deserialize: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        Assert.assertEquals((Object)((FederationRequest)this.expected).getIdentity().getArn(), (Object)actual.getIdentity().getArn());
        logger.info("deserialize: exit");
    }

    @Test
    public void testBackwardsCompatibility() {
        ObjectMapperUtil.assertSerialization(this.expected);
    }

    @Test
    public void testForwardsCompatibility() throws IOException {
        logger.info("testForwardsCompatibility: enter");
        String expectedSerDeFile = this.utils.getResourceOrFail("serde", "PingRequestForwardsCompatible.json");
        this.expectedSerDeText = this.utils.readAllAsString(expectedSerDeFile).trim();
        ByteArrayInputStream input = new ByteArrayInputStream(this.expectedSerDeText.getBytes());
        PingRequest actual = (PingRequest)this.mapper.readValue((InputStream)input, FederationRequest.class);
        logger.info("testForwardsCompatibility: deserialized[{}]", (Object)actual);
        Assert.assertEquals((Object)this.expected, (Object)actual);
        Assert.assertEquals((Object)((FederationRequest)this.expected).getIdentity().getArn(), (Object)actual.getIdentity().getArn());
        logger.info("testForwardsCompatibility: exit");
    }
}

